/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.spi.BeanResolver;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;
import org.hibernate.search.util.impl.common.StringHelper;

public class BeanProviderImpl
implements BeanProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanResolver beanResolver;

    public BeanProviderImpl(BeanResolver beanResolver) {
        this.beanResolver = beanResolver;
    }

    @Override
    public <T> T getBean(Class<?> typeReference, Class<T> expectedClass) {
        if (typeReference == null) {
            throw log.emptyBeanReferenceTypeNull();
        }
        return this.beanResolver.resolve(typeReference, expectedClass);
    }

    @Override
    public <T> T getBean(String nameReference, Class<T> expectedClass) {
        if (StringHelper.isEmpty((String)nameReference)) {
            throw log.emptyBeanReferenceNameNullOrEmpty();
        }
        return this.beanResolver.resolve(nameReference, expectedClass);
    }

    @Override
    public <T> T getBean(BeanReference reference, Class<T> expectedClass) {
        boolean typeProvided;
        if (reference == null) {
            throw log.emptyBeanReferenceNull();
        }
        String nameReference = reference.getName();
        Class<?> typeReference = reference.getType();
        boolean nameProvided = StringHelper.isNotEmpty((String)nameReference);
        boolean bl = typeProvided = typeReference != null;
        if (nameProvided && typeProvided) {
            return this.beanResolver.resolve(nameReference, typeReference, expectedClass);
        }
        if (nameProvided) {
            return this.beanResolver.resolve(nameReference, expectedClass);
        }
        if (typeProvided) {
            return this.beanResolver.resolve(typeReference, expectedClass);
        }
        throw log.emptyBeanReferenceNoNameNoType();
    }
}

