/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean.spi;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.engine.environment.bean.spi.BeanResolver;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoaderHelper;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;

public final class ReflectionBeanResolver
implements BeanResolver {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ClassResolver classResolver;

    public ReflectionBeanResolver(ClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @Override
    public void close() {
    }

    @Override
    public <T> T resolve(Class<?> classOrFactoryClass, Class<T> expectedClass) {
        Object instance = ClassLoaderHelper.untypedInstanceFromClass(classOrFactoryClass, expectedClass.getName());
        return expectedClass.cast(instance);
    }

    @Override
    public <T> T resolve(String classOrFactoryClassName, Class<T> expectedClass) {
        Class<T> classOrFactoryClass = ClassLoaderHelper.classForName(expectedClass, classOrFactoryClassName, expectedClass.getName(), this.classResolver);
        return this.resolve(classOrFactoryClass, expectedClass);
    }

    @Override
    public <T> T resolve(String nameReference, Class<?> typeReference, Class<T> expectedClass) {
        throw log.resolveBeanUsingBothNameAndType(nameReference, typeReference);
    }
}

