/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.util.List;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoadingException;
import org.hibernate.search.engine.logging.spi.MappableTypeModelFormatter;
import org.hibernate.search.engine.logging.spi.MappingKeyFormatter;
import org.hibernate.search.engine.mapper.mapping.spi.MappingKey;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.SearchException;
import org.hibernate.search.util.impl.common.logging.ClassFormatter;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=0, max=9999)})
public interface Log
extends BasicLogger {
    public static final int ID_OFFSET_1 = 0;
    public static final int ID_OFFSET_2 = 500;

    @Message(id=242, value="Hibernate Search failed to initialize component '%1$s' as class '%2$s' doesn't have a public no-arguments constructor")
    public SearchException noPublicNoArgConstructor(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=501, value="Unable to convert configuration property '%1$s' with value '%2$s': %3$s")
    public SearchException unableToConvertConfigurationProperty(String var1, Object var2, String var3, @Cause Exception var4);

    @Message(id=502, value="Invalid value: the value is not an instance of '%1$s' and is not a String that can be parsed: %2$s")
    public SearchException invalidPropertyValue(Class<?> var1, String var2, @Cause Exception var3);

    @Message(id=503, value="Invalid boolean value: expected either a Boolean, the String 'true' or the String 'false'.")
    public SearchException invalidBooleanPropertyValue(@Cause Exception var1);

    @Message(id=504, value="%1$s")
    public SearchException invalidIntegerPropertyValue(String var1, @Cause Exception var2);

    @Message(id=505, value="%1$s")
    public SearchException invalidLongPropertyValue(String var1, @Cause Exception var2);

    @Message(id=506, value="Invalid multi value: expected either a Collection or a String.")
    public SearchException invalidMultiPropertyValue();

    @Message(id=507, value="Cannot add multiple predicates to the query root; use an explicit boolean predicate instead.")
    public SearchException cannotAddMultiplePredicatesToQueryRoot();

    @Message(id=509, value="Cannot add multiple predicates to a nested predicate; use an explicit boolean predicate instead.")
    public SearchException cannotAddMultiplePredicatesToNestedPredicate();

    @Message(id=511, value="Invalid value: the value to match in match predicates must be non-null. Null value was passed to match predicate on fields %1$s")
    public SearchException matchPredicateCannotMatchNullValue(List<String> var1);

    @Message(id=512, value="Invalid value: at least one bound in range predicates must be non-null. Null bounds were passed to range predicate on fields %1$s")
    public SearchException rangePredicateCannotMatchNullValue(List<String> var1);

    @Message(id=513, value="Cannot map type '%1$s' to index '%2$s', because this type is abstract. Index mappings are not inherited: they apply to exact instances of a given type. As a result, mapping an abstract type to an index does not make sense, since the index would always be empty.")
    public SearchException cannotMapAbstractTypeToIndex(@FormatWith(value=MappableTypeModelFormatter.class) MappableTypeModel var1, String var2);

    @Message(id=514, value="Field name '%1$s' is invalid: field names cannot be null or empty.")
    public SearchException relativeFieldNameCannotBeNullOrEmpty(String var1, @Param EventContext var2);

    @Message(id=515, value="Field name '%1$s' is invalid: field names cannot contain a dot ('.'). Remove the dot from your field name, or if you are declaring the field in a bridge and want a tree of fields, declare an object field using the objectField() method.")
    public SearchException relativeFieldNameCannotContainDot(String var1, @Param EventContext var2);

    @Message(id=516, value="Invalid polygon: the first point '%1$s' should be identical to the last point '%2$s' to properly close the polygon.")
    public IllegalArgumentException invalidGeoPolygonFirstPointNotIdenticalToLastPoint(GeoPoint var1, GeoPoint var2);

    @Message(id=517, value="Cannot add a predicate to this DSL context anymore, because the DSL context was already closed. If you want to re-use predicates, do not re-use the predicate DSL context objects, but rather build SearchPredicate objects.")
    public SearchException cannotAddPredicateToUsedContext();

    @Message(id=518, value="Cannot add a sort to this DSL context anymore, because the DSL context was already closed. If you want to re-use sorts, do not re-use the sort DSL context objects, but rather build SearchSort objects.")
    public SearchException cannotAddSortToUsedContext();

    @Message(id=519, value="Hibernate Search bootstrap failed; stopped collecting failures after '%2$s' failures. Failures:\n%1$s")
    public SearchException boostrapCollectedFailureLimitReached(String var1, int var2);

    @Message(id=520, value="Hibernate Search bootstrap failed. Failures:\n%1$s")
    public SearchException bootstrapCollectedFailures(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=521, value="Hibernate Search bootstrap encountered a non-fatal failure; continuing bootstrap for now to list all mapping problems, but the bootstrap process will ultimately be aborted.\nContext: %1$s\nFailure:")
    public void newBootstrapCollectedFailure(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=522, value="Unexpected empty event context; there is a bug in Hibernate Search, please report it")
    public void unexpectedEmptyEventContext(@Cause Throwable var1);

    @Message(id=523, value="Incomplete field definition. You must call createAccessor() to complete the field definition.")
    public SearchException incompleteFieldDefinition(@Param EventContext var1);

    @Message(id=524, value="Multiple calls to createAccessor() for the same field definition. You must call createAccessor() exactly once.")
    public SearchException cannotCreateAccessorMultipleTimes(@Param EventContext var1);

    @Message(id=525, value="Cannot call ifSupported(...) after orElse(...). Use a separate extension() context, or move the orElse(...) call last.")
    public SearchException cannotCallDslExtensionIfSupportedAfterOrElse();

    @Message(id=526, value="None of the provided extensions can be applied to the current context.  Attempted extensions: %1$s. If you want to ignore this, use .extension().ifSupported(...).orElse(ignored -> { }).")
    public SearchException dslExtensionNoMatch(List<?> var1);

    @Message(id=527, value="Unable to instantiate %1$s, class '%2$s': %3$s")
    public SearchException unableToInstantiateComponent(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, String var3, @Cause Exception var4);

    @Message(id=528, value="%2$s defined for component %1$s could not be instantiated because of a security manager error")
    public SearchException securityManagerLoadingError(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Cause Exception var3);

    @Message(id=529, value="Unable to find %1$s implementation class: %2$s")
    public SearchException unableToFindComponentImplementation(String var1, String var2, @Cause Exception var3);

    @Message(id=530, value="Unable to load class [%1$s]")
    public ClassLoadingException unableToLoadTheClass(String var1, @Cause Throwable var2);

    @Message(id=531, value="Trying to map the Type '%1$s' mapped to multiple indexes: '%2$s', '%3$s'.")
    public SearchException multipleIndexMapping(@FormatWith(value=MappableTypeModelFormatter.class) MappableTypeModel var1, String var2, String var3);

    @Message(id=532, value="No mapping registered for mapping key: '%1$s'.")
    public SearchException noMappingRegistered(@FormatWith(value=MappingKeyFormatter.class) MappingKey var1);

    @Message(id=533, value="No backend registered for backend name: '%1$s'.")
    public SearchException noBackendRegistered(String var1);

    @Message(id=534, value="No index manager registered for index manager name: '%1$s'.")
    public SearchException noIndexManagerRegistered(String var1);

    @Message(id=535, value="Got an empty bean reference (type is null).")
    public SearchException emptyBeanReferenceTypeNull();

    @Message(id=536, value="Got an empty bean reference (name is null or empty).")
    public SearchException emptyBeanReferenceNameNullOrEmpty();

    @Message(id=537, value="Got an empty bean reference (reference is null.)")
    public SearchException emptyBeanReferenceNull();

    @Message(id=538, value="Got an empty bean reference (no name, no type).")
    public SearchException emptyBeanReferenceNoNameNoType();

    @Message(id=539, value="This bean resolver does not support bean references using both a name and a type. Got both '%1$s' and '%2$s' in the same reference.")
    public SearchException resolveBeanUsingBothNameAndType(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=540, value="Unable to instantiate class '%1$s': %2$s.")
    public SearchException unableToInstantiateClass(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, @Cause Exception var3);

    @Message(id=541, value="Wrong configuration of %1$s: class %2$s does not implement interface %3$s.")
    public SearchException interfaceImplementedExpected(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @FormatWith(value=ClassFormatter.class) Class<?> var3);

    @Message(id=542, value="Wrong configuration of %1$s: class %2$s is not a subtype of %3$s.")
    public SearchException subtypeExpected(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @FormatWith(value=ClassFormatter.class) Class<?> var3);

    @Message(id=543, value="%2$s defined for component %1$s is an interface: implementation required.")
    public SearchException implementationRequired(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=544, value="%2$s defined for component %1$s is missing an appropriate constructor: expected a public constructor with a single parameter of type Map.")
    public SearchException missingConstructor(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=545, value="Unable to load class for %1$s. Configured implementation %2$s  is not assignable to type %3$s.")
    public SearchException notAssignableImplementation(String var1, String var2, @FormatWith(value=ClassFormatter.class) Class<?> var3);

    @Message(id=546, value="Found an infinite IndexedEmbedded recursion involving path '%1$s' on type '%2$s'.")
    public SearchException indexedEmbeddedCyclicRecursion(String var1, @FormatWith(value=MappableTypeModelFormatter.class) MappableTypeModel var2);
}

