/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.backend.document.IndexObjectFieldAccessor;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaElementImpl;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectNodeBuilder;
import org.hibernate.search.engine.mapper.mapping.building.impl.ConfiguredIndexSchemaNestingContext;
import org.hibernate.search.engine.mapper.mapping.building.impl.NonRootIndexModelBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.impl.NotifyingNestingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexModelBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexSchemaContributionListener;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.mapper.model.spi.SearchModel;

abstract class AbstractIndexModelBindingContext<B extends IndexSchemaObjectNodeBuilder>
implements IndexModelBindingContext {
    final B indexSchemaObjectNodeBuilder;
    private final ConfiguredIndexSchemaNestingContext nestingContext;
    private final SearchModel searchModel = new SearchModel(){};

    AbstractIndexModelBindingContext(B indexSchemaObjectNodeBuilder, ConfiguredIndexSchemaNestingContext nestingContext) {
        this.indexSchemaObjectNodeBuilder = indexSchemaObjectNodeBuilder;
        this.nestingContext = nestingContext;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexSchemaObjectNodeBuilder=" + this.indexSchemaObjectNodeBuilder + ",nestingContext=" + this.nestingContext + "]";
    }

    @Override
    public IndexSchemaElement getSchemaElement() {
        return new IndexSchemaElementImpl<B>(this.indexSchemaObjectNodeBuilder, this.nestingContext);
    }

    @Override
    public IndexSchemaElement getSchemaElement(IndexSchemaContributionListener listener) {
        return new IndexSchemaElementImpl<B>(this.indexSchemaObjectNodeBuilder, new NotifyingNestingContext(this.nestingContext, listener));
    }

    @Override
    public SearchModel getSearchModel() {
        return this.searchModel;
    }

    @Override
    public Optional<IndexModelBindingContext> addIndexedEmbeddedIfIncluded(MappableTypeModel parentTypeModel, String relativePrefix, ObjectFieldStorage storage, Integer maxDepth, Set<String> includePaths) {
        return this.nestingContext.addIndexedEmbeddedIfIncluded(parentTypeModel, relativePrefix, maxDepth, includePaths, new NestedContextBuilderImpl((IndexSchemaObjectNodeBuilder)this.indexSchemaObjectNodeBuilder, storage));
    }

    private static class NestedContextBuilderImpl
    implements ConfiguredIndexSchemaNestingContext.NestedContextBuilder<IndexModelBindingContext> {
        private IndexSchemaObjectNodeBuilder currentNodeBuilder;
        private final ObjectFieldStorage storage;
        private final List<IndexObjectFieldAccessor> parentObjectAccessors = new ArrayList<IndexObjectFieldAccessor>();

        private NestedContextBuilderImpl(IndexSchemaObjectNodeBuilder currentNodeBuilder, ObjectFieldStorage storage) {
            this.currentNodeBuilder = currentNodeBuilder;
            this.storage = storage;
        }

        @Override
        public void appendObject(String objectName) {
            IndexSchemaObjectFieldNodeBuilder nextNodeBuilder = this.currentNodeBuilder.addObjectField(objectName, this.storage);
            this.parentObjectAccessors.add(nextNodeBuilder.createAccessor());
            this.currentNodeBuilder = nextNodeBuilder;
        }

        @Override
        public IndexModelBindingContext build(ConfiguredIndexSchemaNestingContext nestingContext) {
            return new NonRootIndexModelBindingContext(this.currentNodeBuilder, this.parentObjectAccessors, nestingContext);
        }
    }
}

