/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.impl;

import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaNestingContext;
import org.hibernate.search.engine.mapper.mapping.building.impl.IndexSchemaFilter;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;

class ConfiguredIndexSchemaNestingContext
implements IndexSchemaNestingContext {
    private static final ConfiguredIndexSchemaNestingContext ROOT = new ConfiguredIndexSchemaNestingContext(IndexSchemaFilter.root(), "", "");
    private final IndexSchemaFilter filter;
    private final String prefixFromFilter;
    private final String unconsumedPrefix;

    public static ConfiguredIndexSchemaNestingContext root() {
        return ROOT;
    }

    private ConfiguredIndexSchemaNestingContext(IndexSchemaFilter filter, String prefixFromFilter, String unconsumedPrefix) {
        this.filter = filter;
        this.prefixFromFilter = prefixFromFilter;
        this.unconsumedPrefix = unconsumedPrefix;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "filter=" + this.filter + ",prefixFromFilter=" + this.prefixFromFilter + ",unconsumedPrefix=" + this.unconsumedPrefix + "]";
    }

    @Override
    public <T> T nest(String relativeFieldName, Function<String, T> nestedElementFactoryIfIncluded, Function<String, T> nestedElementFactoryIfExcluded) {
        String nameRelativeToFilter = this.prefixFromFilter + relativeFieldName;
        String prefixedRelativeName = this.unconsumedPrefix + relativeFieldName;
        if (this.filter.isPathIncluded(nameRelativeToFilter)) {
            return nestedElementFactoryIfIncluded.apply(prefixedRelativeName);
        }
        return nestedElementFactoryIfExcluded.apply(prefixedRelativeName);
    }

    @Override
    public <T> T nest(String relativeFieldName, BiFunction<String, IndexSchemaNestingContext, T> nestedElementFactoryIfIncluded, BiFunction<String, IndexSchemaNestingContext, T> nestedElementFactoryIfExcluded) {
        String nameRelativeToFilter = this.prefixFromFilter + relativeFieldName;
        String prefixedRelativeName = this.unconsumedPrefix + relativeFieldName;
        if (this.filter.isPathIncluded(nameRelativeToFilter)) {
            ConfiguredIndexSchemaNestingContext nestedFilter = new ConfiguredIndexSchemaNestingContext(this.filter, nameRelativeToFilter + ".", "");
            return nestedElementFactoryIfIncluded.apply(prefixedRelativeName, nestedFilter);
        }
        return nestedElementFactoryIfExcluded.apply(prefixedRelativeName, IndexSchemaNestingContext.excludeAll());
    }

    public <T> Optional<T> addIndexedEmbeddedIfIncluded(MappableTypeModel parentTypeModel, String relativePrefix, Integer nestedMaxDepth, Set<String> nestedPathFilters, NestedContextBuilder<T> contextBuilder) {
        IndexSchemaFilter composedFilter = this.filter.composeWithNested(parentTypeModel, relativePrefix, nestedMaxDepth, nestedPathFilters);
        if (!composedFilter.isEveryPathExcluded()) {
            String prefixToParse = this.unconsumedPrefix + relativePrefix;
            int afterPreviousDotIndex = 0;
            int nextDotIndex = prefixToParse.indexOf(46, afterPreviousDotIndex);
            while (nextDotIndex >= 0) {
                String objectName = prefixToParse.substring(afterPreviousDotIndex, nextDotIndex);
                contextBuilder.appendObject(objectName);
                afterPreviousDotIndex = nextDotIndex + 1;
                nextDotIndex = prefixToParse.indexOf(46, afterPreviousDotIndex);
            }
            String unconsumedPrefix = prefixToParse.substring(afterPreviousDotIndex);
            ConfiguredIndexSchemaNestingContext nestedContext = new ConfiguredIndexSchemaNestingContext(composedFilter, "", unconsumedPrefix);
            return Optional.of(contextBuilder.build(nestedContext));
        }
        return Optional.empty();
    }

    public static interface NestedContextBuilder<T> {
        public void appendObject(String var1);

        public T build(ConfiguredIndexSchemaNestingContext var1);
    }
}

