/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.dsl.predicate.MatchPredicateFieldSetContext;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateTerminalContext;
import org.hibernate.search.engine.search.dsl.predicate.impl.AbstractMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.util.impl.common.LoggerFactory;

class MatchPredicateFieldSetContextImpl<B>
implements MatchPredicateFieldSetContext,
AbstractMultiFieldPredicateCommonState.FieldSetContext<B> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final CommonState<B> commonState;
    private final List<String> absoluteFieldPaths;
    private final List<MatchPredicateBuilder<B>> predicateBuilders = new ArrayList<MatchPredicateBuilder<B>>();

    MatchPredicateFieldSetContextImpl(CommonState<B> commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.absoluteFieldPaths = absoluteFieldPaths;
        SearchPredicateBuilderFactory predicateFactory = commonState.getFactory();
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.predicateBuilders.add(predicateFactory.match(absoluteFieldPath));
        }
    }

    @Override
    public MatchPredicateFieldSetContext orFields(String ... absoluteFieldPaths) {
        return new MatchPredicateFieldSetContextImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public MatchPredicateFieldSetContext boostedTo(float boost) {
        this.predicateBuilders.forEach(b -> b.boost(boost));
        return this;
    }

    @Override
    public SearchPredicateTerminalContext matching(Object value) {
        return this.commonState.matching(value);
    }

    @Override
    public void contributePredicateBuilders(Consumer<B> collector) {
        for (MatchPredicateBuilder<B> predicateBuilder : this.predicateBuilders) {
            collector.accept(predicateBuilder.toImplementation());
        }
    }

    static class CommonState<B>
    extends AbstractMultiFieldPredicateCommonState<B, MatchPredicateFieldSetContextImpl<B>>
    implements SearchPredicateTerminalContext {
        CommonState(SearchPredicateBuilderFactory<?, B> factory) {
            super(factory);
        }

        public SearchPredicateTerminalContext matching(Object value) {
            if (value == null) {
                throw log.matchPredicateCannotMatchNullValue(this.collectAbsoluteFieldPaths());
            }
            this.getQueryBuilders().forEach(b -> b.value(value));
            return this;
        }

        private List<String> collectAbsoluteFieldPaths() {
            return this.getFieldSetContexts().stream().flatMap(f -> ((MatchPredicateFieldSetContextImpl)f).absoluteFieldPaths.stream()).collect(Collectors.toList());
        }

        private Stream<MatchPredicateBuilder<B>> getQueryBuilders() {
            return this.getFieldSetContexts().stream().flatMap(f -> ((MatchPredicateFieldSetContextImpl)f).predicateBuilders.stream());
        }
    }
}

