/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.dsl.predicate.RangeBoundInclusion;
import org.hibernate.search.engine.search.dsl.predicate.RangePredicateFieldSetContext;
import org.hibernate.search.engine.search.dsl.predicate.RangePredicateFromContext;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateTerminalContext;
import org.hibernate.search.engine.search.dsl.predicate.impl.AbstractMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.util.impl.common.LoggerFactory;

class RangePredicateFieldSetContextImpl<B>
implements RangePredicateFieldSetContext,
AbstractMultiFieldPredicateCommonState.FieldSetContext<B> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final CommonState<B> commonState;
    private final List<String> absoluteFieldPaths;
    private final List<RangePredicateBuilder<B>> predicateBuilders = new ArrayList<RangePredicateBuilder<B>>();

    RangePredicateFieldSetContextImpl(CommonState<B> commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.absoluteFieldPaths = absoluteFieldPaths;
        SearchPredicateBuilderFactory predicateFactory = commonState.getFactory();
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.predicateBuilders.add(predicateFactory.range(absoluteFieldPath));
        }
    }

    @Override
    public RangePredicateFieldSetContext orFields(String ... absoluteFieldPaths) {
        return new RangePredicateFieldSetContextImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public RangePredicateFieldSetContext boostedTo(float boost) {
        this.predicateBuilders.forEach(b -> b.boost(boost));
        return this;
    }

    @Override
    public RangePredicateFromContext from(Object value, RangeBoundInclusion inclusion) {
        return this.commonState.from(value, inclusion);
    }

    @Override
    public SearchPredicateTerminalContext above(Object value, RangeBoundInclusion inclusion) {
        return this.commonState.above(value, inclusion);
    }

    @Override
    public SearchPredicateTerminalContext below(Object value, RangeBoundInclusion inclusion) {
        return this.commonState.below(value, inclusion);
    }

    @Override
    public void contributePredicateBuilders(Consumer<B> collector) {
        for (RangePredicateBuilder<B> predicateBuilder : this.predicateBuilders) {
            collector.accept(predicateBuilder.toImplementation());
        }
    }

    static class CommonState<B>
    extends AbstractMultiFieldPredicateCommonState<B, RangePredicateFieldSetContextImpl<B>>
    implements RangePredicateFromContext,
    SearchPredicateTerminalContext {
        private boolean hasNonNullBound = false;

        CommonState(SearchPredicateBuilderFactory<?, B> factory) {
            super(factory);
        }

        @Override
        protected B toImplementation() {
            this.checkHasNonNullBound();
            return super.toImplementation();
        }

        RangePredicateFromContext from(Object value, RangeBoundInclusion inclusion) {
            if (value != null) {
                this.hasNonNullBound = true;
                this.getQueryBuilders().forEach(q -> q.lowerLimit(value));
            }
            switch (inclusion) {
                case EXCLUDED: {
                    this.getQueryBuilders().forEach(RangePredicateBuilder::excludeLowerLimit);
                    break;
                }
            }
            return this;
        }

        @Override
        public SearchPredicateTerminalContext to(Object value, RangeBoundInclusion inclusion) {
            return this.below(value, inclusion);
        }

        SearchPredicateTerminalContext above(Object value, RangeBoundInclusion inclusion) {
            if (value != null) {
                this.hasNonNullBound = true;
                this.getQueryBuilders().forEach(q -> q.lowerLimit(value));
            }
            switch (inclusion) {
                case EXCLUDED: {
                    this.getQueryBuilders().forEach(RangePredicateBuilder::excludeLowerLimit);
                    break;
                }
            }
            this.checkHasNonNullBound();
            return this;
        }

        SearchPredicateTerminalContext below(Object value, RangeBoundInclusion inclusion) {
            if (value != null) {
                this.hasNonNullBound = true;
                this.getQueryBuilders().forEach(q -> q.upperLimit(value));
            }
            switch (inclusion) {
                case EXCLUDED: {
                    this.getQueryBuilders().forEach(RangePredicateBuilder::excludeUpperLimit);
                    break;
                }
            }
            this.checkHasNonNullBound();
            return this;
        }

        private List<String> collectAbsoluteFieldPaths() {
            return this.getFieldSetContexts().stream().flatMap(f -> ((RangePredicateFieldSetContextImpl)f).absoluteFieldPaths.stream()).collect(Collectors.toList());
        }

        private void checkHasNonNullBound() {
            if (!this.hasNonNullBound) {
                throw log.rangePredicateCannotMatchNullValue(this.collectAbsoluteFieldPaths());
            }
        }

        private Stream<RangePredicateBuilder<B>> getQueryBuilders() {
            return this.getFieldSetContexts().stream().flatMap(f -> ((RangePredicateFieldSetContextImpl)f).predicateBuilders.stream());
        }
    }
}

