/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.sort.impl;

import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.search.SearchSort;
import org.hibernate.search.engine.search.dsl.sort.DistanceSortContext;
import org.hibernate.search.engine.search.dsl.sort.FieldSortContext;
import org.hibernate.search.engine.search.dsl.sort.NonEmptySortContext;
import org.hibernate.search.engine.search.dsl.sort.ScoreSortContext;
import org.hibernate.search.engine.search.dsl.sort.SearchSortContainerContext;
import org.hibernate.search.engine.search.dsl.sort.SearchSortContainerContextExtension;
import org.hibernate.search.engine.search.dsl.sort.SearchSortContainerExtensionContext;
import org.hibernate.search.engine.search.dsl.sort.impl.DistanceSortContextImpl;
import org.hibernate.search.engine.search.dsl.sort.impl.FieldSortContextImpl;
import org.hibernate.search.engine.search.dsl.sort.impl.ScoreSortContextImpl;
import org.hibernate.search.engine.search.dsl.sort.impl.SearchSortContainerExtensionContextImpl;
import org.hibernate.search.engine.search.dsl.sort.impl.SearchSortDslContextImpl;
import org.hibernate.search.engine.search.dsl.sort.spi.NonEmptySortContextImpl;
import org.hibernate.search.engine.search.dsl.sort.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.sort.spi.SearchSortBuilderFactory;
import org.hibernate.search.engine.spatial.GeoPoint;

public class DefaultSearchSortContainerContext<B>
implements SearchSortContainerContext {
    private final SearchSortBuilderFactory<?, B> factory;
    private final SearchSortDslContext<? super B> dslContext;

    public DefaultSearchSortContainerContext(SearchSortBuilderFactory<?, B> factory) {
        this.factory = factory;
        this.dslContext = new SearchSortDslContextImpl<B>(factory);
    }

    public DefaultSearchSortContainerContext(SearchSortBuilderFactory<?, B> factory, SearchSortDslContext<? super B> dslContext) {
        this.factory = factory;
        this.dslContext = dslContext;
    }

    @Override
    public NonEmptySortContext by(SearchSort sort) {
        this.factory.toImplementation(sort, this.dslContext::addChild);
        return this.nonEmptyContext();
    }

    @Override
    public ScoreSortContext byScore() {
        ScoreSortContextImpl<B> child = new ScoreSortContextImpl<B>(this, this.factory, this.dslContext);
        this.dslContext.addChild(child);
        return child;
    }

    @Override
    public NonEmptySortContext byIndexOrder() {
        this.dslContext.addChild(this.factory.indexOrder());
        return this.nonEmptyContext();
    }

    @Override
    public FieldSortContext byField(String absoluteFieldPath) {
        FieldSortContextImpl<B> child = new FieldSortContextImpl<B>(this, this.factory, this.dslContext, absoluteFieldPath);
        this.dslContext.addChild(child);
        return child;
    }

    @Override
    public DistanceSortContext byDistance(String absoluteFieldPath, GeoPoint location) {
        DistanceSortContextImpl<B> child = new DistanceSortContextImpl<B>(this, this.factory, this.dslContext, absoluteFieldPath, location);
        this.dslContext.addChild(child);
        return child;
    }

    @Override
    public <T> T extension(SearchSortContainerContextExtension<T> extension) {
        return DslExtensionState.returnIfSupported(extension, extension.extendOptional(this, this.factory, this.dslContext));
    }

    @Override
    public SearchSortContainerExtensionContext extension() {
        return new SearchSortContainerExtensionContextImpl<B>(this, this.factory, this.dslContext);
    }

    private NonEmptySortContext nonEmptyContext() {
        return new NonEmptySortContextImpl(this, this.dslContext);
    }
}

