/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.function.Function;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaObjectField;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaNestingContext;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaObjectFieldImpl;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectNodeBuilder;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFinalStep;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.impl.StringHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class IndexSchemaElementImpl<B extends IndexSchemaObjectNodeBuilder>
implements IndexSchemaElement {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexFieldTypeFactory typeFactory;
    final B objectNodeBuilder;
    private final IndexSchemaNestingContext nestingContext;
    private final boolean directChildrenAreMultiValuedByDefault;

    public IndexSchemaElementImpl(IndexFieldTypeFactory typeFactory, B objectNodeBuilder, IndexSchemaNestingContext nestingContext, boolean directChildrenAreMultiValuedByDefault) {
        this.typeFactory = typeFactory;
        this.objectNodeBuilder = objectNodeBuilder;
        this.nestingContext = nestingContext;
        this.directChildrenAreMultiValuedByDefault = directChildrenAreMultiValuedByDefault;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "objectNodeBuilder=" + this.objectNodeBuilder + ",nestingContext=" + this.nestingContext + "]";
    }

    @Override
    public <F> IndexSchemaFieldOptionsStep<?, IndexFieldReference<F>> field(String relativeFieldName, IndexFieldType<F> type) {
        this.checkRelativeFieldName(relativeFieldName);
        IndexSchemaFieldOptionsStep fieldFinalStep = this.nestingContext.nest(relativeFieldName, prefixedName -> this.objectNodeBuilder.addField((String)prefixedName, type), prefixedName -> this.objectNodeBuilder.createExcludedField((String)prefixedName, type));
        if (this.directChildrenAreMultiValuedByDefault) {
            fieldFinalStep.multiValued();
        }
        return fieldFinalStep;
    }

    @Override
    public <F> IndexSchemaFieldOptionsStep<?, IndexFieldReference<F>> field(String relativeFieldName, Function<? super IndexFieldTypeFactory, ? extends IndexFieldTypeFinalStep<F>> typeContributor) {
        return this.field(relativeFieldName, typeContributor.apply(this.typeFactory));
    }

    @Override
    public IndexSchemaObjectField objectField(String relativeFieldName, ObjectFieldStorage storage) {
        this.checkRelativeFieldName(relativeFieldName);
        IndexSchemaObjectField objectField = this.nestingContext.nest(relativeFieldName, (prefixedName, filter) -> {
            IndexSchemaObjectFieldNodeBuilder objectFieldBuilder = this.objectNodeBuilder.addObjectField((String)prefixedName, storage);
            return new IndexSchemaObjectFieldImpl(this.typeFactory, objectFieldBuilder, (IndexSchemaNestingContext)filter, false);
        }, (prefixedName, filter) -> {
            IndexSchemaObjectFieldNodeBuilder objectFieldBuilder = this.objectNodeBuilder.createExcludedObjectField((String)prefixedName, storage);
            return new IndexSchemaObjectFieldImpl(this.typeFactory, objectFieldBuilder, (IndexSchemaNestingContext)filter, false);
        });
        if (this.directChildrenAreMultiValuedByDefault) {
            objectField.multiValued();
        }
        return objectField;
    }

    private void checkRelativeFieldName(String relativeFieldName) {
        if (StringHelper.isEmpty((String)relativeFieldName)) {
            throw log.relativeFieldNameCannotBeNullOrEmpty(relativeFieldName, this.objectNodeBuilder.getEventContext());
        }
        if (relativeFieldName.contains(".")) {
            throw log.relativeFieldNameCannotContainDot(relativeFieldName, this.objectNodeBuilder.getEventContext());
        }
    }
}

