/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.spi;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;

public final class IndexedEmbeddedDefinition {
    private final MappableTypeModel definingTypeModel;
    private final String relativePrefix;
    private final ObjectFieldStorage storage;
    private final Set<String> includePaths;
    private final Integer maxDepth;

    public IndexedEmbeddedDefinition(MappableTypeModel definingTypeModel, String relativePrefix, ObjectFieldStorage storage, Integer maxDepth, Set<String> includePaths) {
        this.definingTypeModel = definingTypeModel;
        this.relativePrefix = relativePrefix;
        this.storage = storage;
        this.includePaths = includePaths == null ? Collections.emptySet() : new LinkedHashSet<String>(includePaths);
        this.maxDepth = maxDepth == null && !this.includePaths.isEmpty() ? Integer.valueOf(0) : maxDepth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedEmbeddedDefinition that = (IndexedEmbeddedDefinition)o;
        return this.definingTypeModel.equals(that.definingTypeModel) && this.relativePrefix.equals(that.relativePrefix) && Objects.equals(this.maxDepth, that.maxDepth) && this.includePaths.equals(that.includePaths);
    }

    public int hashCode() {
        return Objects.hash(this.definingTypeModel, this.relativePrefix, this.maxDepth, this.includePaths);
    }

    public MappableTypeModel getDefiningTypeModel() {
        return this.definingTypeModel;
    }

    public String getRelativePrefix() {
        return this.relativePrefix;
    }

    public ObjectFieldStorage getStorage() {
        return this.storage;
    }

    public Set<String> getIncludePaths() {
        return this.includePaths;
    }

    public Integer getMaxDepth() {
        return this.maxDepth;
    }
}

