/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.work.execution.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.util.common.AssertionFailure;

public final class IndexIndexingPlanExecutionReport<R> {
    private final Throwable throwable;
    private final List<R> failingEntityReferences;

    public static <R> Builder<R> builder() {
        return new Builder();
    }

    public static <R> CompletableFuture<IndexIndexingPlanExecutionReport<R>> allOf(List<CompletableFuture<IndexIndexingPlanExecutionReport<R>>> reportFutures) {
        if (reportFutures.size() == 1) {
            return reportFutures.get(0);
        }
        CompletionStage<Builder<Object>> reportBuilderFuture = CompletableFuture.completedFuture(IndexIndexingPlanExecutionReport.builder());
        for (CompletableFuture<IndexIndexingPlanExecutionReport<R>> future : reportFutures) {
            reportBuilderFuture = reportBuilderFuture.thenCombine(future, Builder::add);
        }
        return reportBuilderFuture.thenApply(Builder::build);
    }

    private IndexIndexingPlanExecutionReport(Builder<R> builder) {
        this.failingEntityReferences = ((Builder)builder).failingEntityReferences == null ? Collections.emptyList() : Collections.unmodifiableList(((Builder)builder).failingEntityReferences);
        this.throwable = ((Builder)builder).throwable == null && !this.failingEntityReferences.isEmpty() ? new AssertionFailure("Unknown throwable: missing throwable when reporting the failure. There is probably a bug in Hibernate Search, please report it.") : ((Builder)builder).throwable;
    }

    public Optional<Throwable> getThrowable() {
        return Optional.ofNullable(this.throwable);
    }

    public List<R> getFailingEntityReferences() {
        return this.failingEntityReferences;
    }

    public static final class Builder<R> {
        private Throwable throwable;
        private List<R> failingEntityReferences;

        private Builder() {
        }

        public Builder<R> add(IndexIndexingPlanExecutionReport<R> report) {
            report.getThrowable().ifPresent(this::throwable);
            for (R failingEntityReference : report.getFailingEntityReferences()) {
                this.failingEntityReference(failingEntityReference);
            }
            return this;
        }

        public Builder<R> throwable(Throwable throwable) {
            if (this.throwable == null) {
                this.throwable = throwable;
            } else if (this.throwable != throwable) {
                this.throwable.addSuppressed(throwable);
            }
            return this;
        }

        public Builder<R> failingEntityReference(R reference) {
            if (this.failingEntityReferences == null) {
                this.failingEntityReferences = new ArrayList<R>();
            }
            this.failingEntityReferences.add(reference);
            return this;
        }

        public Builder<R> failingEntityReference(EntityReferenceFactory<R> referenceFactory, String typeName, Object entityIdentifier) {
            try {
                this.failingEntityReference(referenceFactory.createEntityReference(typeName, entityIdentifier));
            }
            catch (RuntimeException e) {
                this.throwable(e);
            }
            return this;
        }

        public IndexIndexingPlanExecutionReport<R> build() {
            return new IndexIndexingPlanExecutionReport(this);
        }
    }
}

