/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.impl.EngineConfigurationUtils;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.common.impl.BackendStartContextImpl;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.reporting.spi.RootFailureCollector;

class BackendNonStartedState {
    private final String backendName;
    private final BackendImplementor backend;

    BackendNonStartedState(String backendName, BackendImplementor backend) {
        this.backendName = backendName;
        this.backend = backend;
    }

    void closeOnFailure() {
        this.backend.stop();
    }

    BackendImplementor start(RootFailureCollector rootFailureCollector, BeanResolver beanResolver, ConfigurationPropertySource rootPropertySource, ThreadPoolProvider threadPoolProvider) {
        ContextualFailureCollector backendFailureCollector = rootFailureCollector.withContext(EventContexts.fromBackendName(this.backendName));
        ConfigurationPropertySource backendPropertySource = EngineConfigurationUtils.getBackend(rootPropertySource, this.backendName);
        BackendStartContextImpl startContext = new BackendStartContextImpl(backendFailureCollector, beanResolver, backendPropertySource, threadPoolProvider);
        try {
            this.backend.start(startContext);
        }
        catch (RuntimeException e) {
            backendFailureCollector.add(e);
        }
        return this.backend;
    }
}

