/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.dsl.spi;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class DslExtensionState<R> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private boolean appliedAtLeastOneExtension = false;
    private boolean appliedOrElse = false;
    private R result = null;
    private List<Object> unsupportedExtensions;

    public static <E> E returnIfSupported(Object extension, Optional<E> extendedContextOptional) {
        DslExtensionState<Object> state = new DslExtensionState<Object>();
        state.ifSupported(extension, extendedContextOptional, (E context) -> context);
        return (E)state.orElseFail();
    }

    public <E> void ifSupported(Object extension, Optional<E> extendedContextOptional, Consumer<E> extendedContextConsumer) {
        this.ifSupported(extension, extendedContextOptional, (E c) -> {
            extendedContextConsumer.accept(c);
            return null;
        });
    }

    public <E> void ifSupported(Object extension, Optional<E> extendedContextOptional, Function<E, ? extends R> extendedContextFunction) {
        if (this.appliedOrElse) {
            throw log.cannotCallDslExtensionIfSupportedAfterOrElse();
        }
        if (!this.appliedAtLeastOneExtension) {
            if (extendedContextOptional.isPresent()) {
                this.appliedAtLeastOneExtension = true;
                this.result = extendedContextFunction.apply(extendedContextOptional.get());
            } else {
                if (this.unsupportedExtensions == null) {
                    this.unsupportedExtensions = new ArrayList<Object>();
                }
                this.unsupportedExtensions.add(extension);
            }
        }
    }

    public <T> R orElse(T defaultContext, Consumer<T> defaultContextConsumer) {
        return (R)this.orElse(defaultContext, (T c) -> {
            defaultContextConsumer.accept(c);
            return null;
        });
    }

    public <T> R orElse(T defaultContext, Function<T, ? extends R> defaultContextFunction) {
        if (!this.appliedAtLeastOneExtension) {
            this.appliedOrElse = true;
            this.result = defaultContextFunction.apply(defaultContext);
        }
        return this.result;
    }

    public R orElseFail() {
        if (!this.appliedAtLeastOneExtension) {
            this.appliedOrElse = true;
            throw log.dslExtensionNoMatch(this.unsupportedExtensions == null ? Collections.emptyList() : this.unsupportedExtensions);
        }
        return this.result;
    }
}

