/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.MatchPredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.MatchPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class MatchPredicateFieldMoreStepImpl
implements MatchPredicateFieldMoreStep<MatchPredicateFieldMoreStepImpl, MatchPredicateOptionsStep<?>>,
AbstractBooleanMultiFieldPredicateCommonState.FieldSetState {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final CommonState commonState;
    private final List<MatchPredicateBuilder> predicateBuilders = new ArrayList<MatchPredicateBuilder>();
    private Float fieldSetBoost;

    MatchPredicateFieldMoreStepImpl(CommonState commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        SearchPredicateBuilderFactory<?> predicateFactory = commonState.getFactory();
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.predicateBuilders.add(predicateFactory.match(absoluteFieldPath));
        }
    }

    @Override
    public MatchPredicateFieldMoreStepImpl fields(String ... absoluteFieldPaths) {
        return new MatchPredicateFieldMoreStepImpl(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public MatchPredicateFieldMoreStepImpl boost(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this;
    }

    @Override
    public MatchPredicateOptionsStep<?> matching(Object value, ValueConvert convert) {
        return this.commonState.matching(value, convert);
    }

    @Override
    public void contributePredicates(Consumer<SearchPredicate> collector) {
        for (MatchPredicateBuilder predicateBuilder : this.predicateBuilders) {
            this.commonState.applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.build());
        }
    }

    static class CommonState
    extends AbstractBooleanMultiFieldPredicateCommonState<CommonState, MatchPredicateFieldMoreStepImpl>
    implements MatchPredicateOptionsStep<CommonState> {
        CommonState(SearchPredicateDslContext<?> dslContext) {
            super(dslContext);
        }

        MatchPredicateOptionsStep<?> matching(Object value, ValueConvert convert) {
            Contracts.assertNotNull((Object)value, (String)"value");
            Contracts.assertNotNull((Object)((Object)convert), (String)"convert");
            for (MatchPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (MatchPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders) {
                    predicateBuilder.value(value, convert);
                }
            }
            return this;
        }

        @Override
        public CommonState fuzzy(int maxEditDistance, int exactPrefixLength) {
            if (maxEditDistance < 0 || 2 < maxEditDistance) {
                throw log.invalidFuzzyMaximumEditDistance(maxEditDistance);
            }
            if (exactPrefixLength < 0) {
                throw log.invalidExactPrefixLength(exactPrefixLength);
            }
            for (MatchPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (MatchPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders) {
                    predicateBuilder.fuzzy(maxEditDistance, exactPrefixLength);
                }
            }
            return this;
        }

        @Override
        public CommonState analyzer(String analyzerName) {
            for (MatchPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (MatchPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders) {
                    predicateBuilder.analyzer(analyzerName);
                }
            }
            return this;
        }

        @Override
        public CommonState skipAnalysis() {
            for (MatchPredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (MatchPredicateBuilder predicateBuilder : fieldSetState.predicateBuilders) {
                    predicateBuilder.skipAnalysis();
                }
            }
            return this;
        }

        @Override
        protected CommonState thisAsS() {
            return this;
        }
    }
}

