/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.query.dsl.impl;

import java.util.List;
import java.util.function.Function;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.ProjectionFinalStep;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.query.dsl.SearchQueryOptionsStep;
import org.hibernate.search.engine.search.query.dsl.impl.DefaultSearchQueryOptionsStep;
import org.hibernate.search.engine.search.query.dsl.spi.AbstractSearchQueryOptionsStep;
import org.hibernate.search.engine.search.query.dsl.spi.AbstractSearchQuerySelectStep;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

public final class DefaultSearchQuerySelectStep<R, E, LOS, C>
extends AbstractSearchQuerySelectStep<SearchQueryOptionsStep<?, E, LOS, ?, ?>, R, E, LOS, SearchProjectionFactory<R, E>, SearchPredicateFactory, C> {
    private final IndexScope<C> indexScope;
    private final BackendSessionContext sessionContext;
    private final LoadingContextBuilder<R, E, LOS> loadingContextBuilder;

    public DefaultSearchQuerySelectStep(IndexScope<C> indexScope, BackendSessionContext sessionContext, LoadingContextBuilder<R, E, LOS> loadingContextBuilder) {
        this.indexScope = indexScope;
        this.sessionContext = sessionContext;
        this.loadingContextBuilder = loadingContextBuilder;
    }

    public DefaultSearchQueryOptionsStep<E, LOS, C> selectEntity() {
        SearchQueryBuilder<E, C> builder = this.indexScope.searchQueryBuilderFactory().selectEntity(this.sessionContext, this.loadingContextBuilder);
        return new DefaultSearchQueryOptionsStep<E, LOS, C>(this.indexScope, builder, this.loadingContextBuilder);
    }

    public DefaultSearchQueryOptionsStep<R, LOS, C> selectEntityReference() {
        SearchQueryBuilder<R, C> builder = this.indexScope.searchQueryBuilderFactory().selectEntityReference(this.sessionContext, this.loadingContextBuilder);
        return new DefaultSearchQueryOptionsStep<R, LOS, C>(this.indexScope, builder, this.loadingContextBuilder);
    }

    public <P> DefaultSearchQueryOptionsStep<P, LOS, C> select(Function<? super SearchProjectionFactory<R, E>, ? extends ProjectionFinalStep<P>> projectionContributor) {
        SearchProjectionFactory factory = this.createDefaultProjectionFactory();
        SearchProjection<P> projection = projectionContributor.apply(factory).toProjection();
        return this.select((SearchProjection)projection);
    }

    public <P> DefaultSearchQueryOptionsStep<P, LOS, C> select(SearchProjection<P> projection) {
        SearchQueryBuilder<P, C> builder = this.indexScope.searchQueryBuilderFactory().select(this.sessionContext, (LoadingContextBuilder<?, ?, ?>)this.loadingContextBuilder, projection);
        return new DefaultSearchQueryOptionsStep<P, LOS, C>(this.indexScope, builder, this.loadingContextBuilder);
    }

    public DefaultSearchQueryOptionsStep<List<?>, LOS, C> select(SearchProjection<?> ... projections) {
        SearchQueryBuilder<List<R>, C> builder = this.indexScope.searchQueryBuilderFactory().select(this.sessionContext, this.loadingContextBuilder, projections);
        return new DefaultSearchQueryOptionsStep<List<R>, LOS, C>(this.indexScope, builder, this.loadingContextBuilder);
    }

    @Override
    public SearchQueryOptionsStep<?, E, LOS, ?, ?> where(Function<? super SearchPredicateFactory, ? extends PredicateFinalStep> predicateContributor) {
        return ((AbstractSearchQueryOptionsStep)this.selectEntity()).where(predicateContributor);
    }

    @Override
    public SearchQueryOptionsStep<?, E, LOS, ?, ?> where(SearchPredicate predicate) {
        return ((AbstractSearchQueryOptionsStep)this.selectEntity()).where(predicate);
    }

    @Override
    protected IndexScope<C> indexScope() {
        return this.indexScope;
    }

    @Override
    protected BackendSessionContext sessionContext() {
        return this.sessionContext;
    }

    @Override
    protected LoadingContextBuilder<R, E, LOS> loadingContextBuilder() {
        return this.loadingContextBuilder;
    }
}

