/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.sort.dsl.impl;

import java.util.function.Function;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.DistanceSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.engine.search.sort.dsl.spi.AbstractSortThenStep;
import org.hibernate.search.engine.search.sort.dsl.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;

public class DistanceSortOptionsStepImpl<PDF extends SearchPredicateFactory>
extends AbstractSortThenStep
implements DistanceSortOptionsStep<DistanceSortOptionsStepImpl<PDF>, PDF> {
    private final DistanceSortBuilder builder;
    private final SearchSortDslContext<?, ? extends PDF> dslContext;

    public DistanceSortOptionsStepImpl(SearchSortDslContext<?, ? extends PDF> dslContext, String absoluteFieldPath, GeoPoint center) {
        super(dslContext);
        this.dslContext = dslContext;
        this.builder = dslContext.builderFactory().distance(absoluteFieldPath);
        this.builder.center(center);
    }

    @Override
    public DistanceSortOptionsStepImpl<PDF> order(SortOrder order) {
        this.builder.order(order);
        return this;
    }

    @Override
    public DistanceSortOptionsStepImpl<PDF> mode(SortMode mode) {
        this.builder.mode(mode);
        return this;
    }

    @Override
    public DistanceSortOptionsStepImpl<PDF> filter(Function<? super PDF, ? extends PredicateFinalStep> clauseContributor) {
        SearchPredicate predicate = clauseContributor.apply(this.dslContext.predicateFactory()).toPredicate();
        return this.filter(predicate);
    }

    @Override
    public DistanceSortOptionsStepImpl<PDF> filter(SearchPredicate searchPredicate) {
        this.builder.filter(searchPredicate);
        return this;
    }

    @Override
    protected SearchSort build() {
        return this.builder.build();
    }
}

