package org.hibernate.search.engine.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class ExecutorLog_$logger extends DelegatingBasicLogger implements ExecutorLog, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ExecutorLog_$logger.class.getName();
    public ExecutorLog_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void startingExecutor(final String name) {
        super.log.logf(FQCN, DEBUG, null, startingExecutor$str(), name);
    }
    protected String startingExecutor$str() {
        return "HSEARCH000230: Starting executor '%1$s'";
    }
    @Override
    public final void stoppingExecutor(final String indexName) {
        super.log.logf(FQCN, DEBUG, null, stoppingExecutor$str(), indexName);
    }
    protected String stoppingExecutor$str() {
        return "HSEARCH000231: Stopping executor '%1$s'";
    }
    protected String threadInterruptedWhileSubmittingWork$str() {
        return "HSEARCH000562: Unable to submit work to '%1$s': thread received interrupt signal. The work has been discarded.";
    }
    @Override
    public final SearchException threadInterruptedWhileSubmittingWork(final String orchestratorName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), threadInterruptedWhileSubmittingWork$str(), orchestratorName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String submittedWorkToStoppedOrchestrator$str() {
        return "HSEARCH000563: Unable to submit work to '%1$s': this orchestrator is stopped. The work has been discarded.";
    }
    @Override
    public final SearchException submittedWorkToStoppedOrchestrator(final String orchestratorName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), submittedWorkToStoppedOrchestrator$str(), orchestratorName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void numberOfWorksInExecutor(final int workCount, final String name) {
        super.log.logf(FQCN, TRACE, null, numberOfWorksInExecutor$str(), workCount, name);
    }
    protected String numberOfWorksInExecutor$str() {
        return "HSEARCH000630: Processing %d works in executor '%s'";
    }
    @Override
    public final void numberOfProcessedWorksInExecutor(final int workCount, final String name) {
        super.log.logf(FQCN, TRACE, null, numberOfProcessedWorksInExecutor$str(), workCount, name);
    }
    protected String numberOfProcessedWorksInExecutor$str() {
        return "HSEARCH000631: Processed %d works in executor '%s'";
    }
    @Override
    public final void schedulingTask(final String name) {
        super.log.logf(FQCN, TRACE, null, schedulingTask$str(), name);
    }
    protected String schedulingTask$str() {
        return "HSEARCH000632: Scheduling task '%s'.";
    }
    @Override
    public final void runningTask(final String name) {
        super.log.logf(FQCN, TRACE, null, runningTask$str(), name);
    }
    protected String runningTask$str() {
        return "HSEARCH000633: Running task '%s'";
    }
    @Override
    public final void completedTask(final String name) {
        super.log.logf(FQCN, TRACE, null, completedTask$str(), name);
    }
    protected String completedTask$str() {
        return "HSEARCH000634: Completed task '%s'";
    }
}
