/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.reporting.impl;

import java.util.List;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.engine.logging.impl.EngineMiscLog;
import org.hibernate.search.engine.reporting.EntityIndexingFailureContext;
import org.hibernate.search.engine.reporting.FailureContext;
import org.hibernate.search.engine.reporting.FailureHandler;

public class LogFailureHandler
implements FailureHandler {
    private static final int FAILURE_FLOODING_THRESHOLD = 100;
    public static final String NAME = "log";

    @Override
    public void handle(FailureContext context) {
        EngineMiscLog.INSTANCE.exceptionOccurred(this.formatMessage(context).toString(), context.throwable());
    }

    @Override
    public void handle(EntityIndexingFailureContext context) {
        EngineMiscLog.INSTANCE.exceptionOccurred(this.formatMessage(context).toString(), context.throwable());
    }

    @Override
    public long failureFloodingThreshold() {
        return 100L;
    }

    private StringBuilder formatMessage(FailureContext context) {
        Throwable throwable = context.throwable();
        Object failingOperation = context.failingOperation();
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Exception occurred ").append(throwable).append("\n");
        messageBuilder.append("Failing operation:\n");
        messageBuilder.append(failingOperation);
        messageBuilder.append("\n");
        return messageBuilder;
    }

    private StringBuilder formatMessage(EntityIndexingFailureContext context) {
        List<EntityReference> entityReferences = context.failingEntityReferences();
        StringBuilder messageBuilder = this.formatMessage((FailureContext)context);
        if (!entityReferences.isEmpty()) {
            messageBuilder.append("Entities that could not be indexed correctly:\n");
            for (EntityReference entityReference : entityReferences) {
                messageBuilder.append(entityReference);
                messageBuilder.append(" ");
            }
        }
        return messageBuilder;
    }
}

