/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.query.spi;

import java.util.List;
import java.util.Optional;
import org.hibernate.search.engine.logging.impl.QueryLog;
import org.hibernate.search.engine.search.query.SearchResult;
import org.hibernate.search.engine.search.query.spi.SearchQueryImplementor;

public abstract class AbstractSearchQuery<H, R extends SearchResult<H>>
implements SearchQueryImplementor<H> {
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.queryString() + ")";
    }

    public R fetchAll() {
        return this.fetch(null, null);
    }

    public R fetch(Integer limit) {
        return this.fetch(null, limit);
    }

    public abstract R fetch(Integer var1, Integer var2);

    @Override
    public List<H> fetchAllHits() {
        return this.fetchHits(null, null);
    }

    @Override
    public List<H> fetchHits(Integer limit) {
        return this.fetchHits(null, limit);
    }

    @Override
    public Optional<H> fetchSingleHit() {
        List<H> hits = this.fetchHits(2);
        int fetchedHitCount = hits.size();
        if (fetchedHitCount == 0) {
            return Optional.empty();
        }
        if (fetchedHitCount > 1) {
            throw QueryLog.INSTANCE.nonSingleHit();
        }
        return Optional.of(hits.get(0));
    }
}

