/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingIndexedTypeContext;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexingNotifier;
import org.hibernate.search.mapper.orm.massindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.mapper.orm.massindexing.impl.StatelessSessionAwareRunnable;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class IdentifierProducer<E, I>
implements StatelessSessionAwareRunnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final SessionFactory sessionFactory;
    private final MassIndexingNotifier notifier;
    private final String tenantId;
    private final HibernateOrmMassIndexingIndexedTypeContext<E> type;
    private final SingularAttribute<? super E, I> idAttributeOfType;
    private final Set<Class<? extends E>> includedTypesFilter;
    private final ProducerConsumerQueue<List<I>> destination;
    private final int batchSize;
    private final long objectsLimit;
    private final int idFetchSize;

    IdentifierProducer(SessionFactory sessionFactory, String tenantId, MassIndexingNotifier notifier, ProducerConsumerQueue<List<I>> fromIdentifierListToEntities, int objectLoadingBatchSize, HibernateOrmMassIndexingIndexedTypeContext<E> type, SingularAttribute<? super E, I> idAttributeOfType, Set<Class<? extends E>> includedTypesFilter, long objectsLimit, int idFetchSize) {
        this.sessionFactory = sessionFactory;
        this.tenantId = tenantId;
        this.notifier = notifier;
        this.type = type;
        this.idAttributeOfType = idAttributeOfType;
        this.includedTypesFilter = includedTypesFilter;
        this.destination = fromIdentifierListToEntities;
        this.batchSize = objectLoadingBatchSize;
        this.objectsLimit = objectsLimit;
        this.idFetchSize = idFetchSize;
        log.trace("created");
    }

    @Override
    public void run(StatelessSession upperSession) {
        log.trace("started");
        try {
            this.inTransactionWrapper(upperSession);
        }
        catch (RuntimeException exception) {
            this.notifier.notifyRunnableFailure(exception, log.massIndexerFetchingIds(this.type.jpaEntityName()));
        }
        finally {
            this.destination.producerStopping();
        }
        log.trace("finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inTransactionWrapper(StatelessSession upperSession) {
        StatelessSession session = upperSession;
        if (upperSession == null) {
            session = this.tenantId == null ? this.sessionFactory.openStatelessSession() : this.sessionFactory.withStatelessOptions().tenantIdentifier(this.tenantId).openStatelessSession();
        }
        try {
            boolean controlTransactions;
            Transaction transaction = ((SharedSessionContractImplementor)session).accessTransaction();
            boolean bl = controlTransactions = !transaction.isActive();
            if (controlTransactions) {
                transaction.begin();
            }
            try {
                this.loadAllIdentifiers(session);
            }
            finally {
                if (controlTransactions) {
                    transaction.commit();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (upperSession == null) {
                session.close();
            }
        }
    }

    private void loadAllIdentifiers(StatelessSession session) throws InterruptedException {
        long totalCount = (Long)this.createTotalCountQuery(session).uniqueResult();
        if (this.objectsLimit != 0L && this.objectsLimit < totalCount) {
            totalCount = this.objectsLimit;
        }
        if (log.isDebugEnabled()) {
            log.debugf("going to fetch %d primary keys", totalCount);
        }
        this.notifier.notifyAddedTotalCount(totalCount);
        ArrayList<Object> destinationList = new ArrayList<Object>(this.batchSize);
        long counter = 0L;
        try (ScrollableResults results = this.createIdentifiersQuery(session).scroll(ScrollMode.FORWARD_ONLY);){
            while (results.next()) {
                Object id = results.get(0);
                destinationList.add(id);
                if (destinationList.size() == this.batchSize) {
                    SharedSessionContractImplementor sessionImpl = (SharedSessionContractImplementor)session;
                    if (!sessionImpl.isTransactionInProgress()) {
                        throw log.transactionNotActiveWhileProducingIdsForBatchIndexing(this.type.jpaEntityName());
                    }
                    this.enqueueList(destinationList);
                    destinationList = new ArrayList(this.batchSize);
                }
                if (++counter != totalCount) continue;
                break;
            }
        }
        this.enqueueList(destinationList);
    }

    private Query<Long> createTotalCountQuery(StatelessSession session) {
        CriteriaBuilder criteriaBuilder = this.sessionFactory.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root root = criteriaQuery.from(this.type.entityTypeDescriptor());
        criteriaQuery.select((Selection)criteriaBuilder.count((Expression)root));
        if (!this.includedTypesFilter.isEmpty()) {
            criteriaQuery.where((Expression)root.type().in(this.includedTypesFilter));
        }
        return session.createQuery(criteriaQuery).setCacheable(false);
    }

    private Query<I> createIdentifiersQuery(StatelessSession session) {
        CriteriaBuilder criteriaBuilder = this.sessionFactory.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.idAttributeOfType.getJavaType());
        Root root = criteriaQuery.from(this.type.entityTypeDescriptor());
        Path idPath = root.get(this.idAttributeOfType);
        criteriaQuery.select((Selection)idPath);
        if (!this.includedTypesFilter.isEmpty()) {
            criteriaQuery.where((Expression)root.type().in(this.includedTypesFilter));
        }
        return session.createQuery(criteriaQuery).setCacheable(false).setFetchSize(this.idFetchSize);
    }

    private void enqueueList(List<I> idsList) throws InterruptedException {
        if (!idsList.isEmpty()) {
            this.destination.put(idsList);
            log.tracef("produced a list of ids %s", idsList);
        }
    }
}

