/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.scope.impl;

import java.util.Set;
import org.hibernate.search.engine.backend.scope.IndexScopeExtension;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.search.aggregation.dsl.SearchAggregationFactory;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.entity.SearchIndexedEntity;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmSelectionLoadingContext;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexer;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingContext;
import org.hibernate.search.mapper.orm.schema.management.SearchSchemaManager;
import org.hibernate.search.mapper.orm.schema.management.impl.SearchSchemaManagerImpl;
import org.hibernate.search.mapper.orm.scope.SearchScope;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeIndexedTypeContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeMappingContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeSessionContext;
import org.hibernate.search.mapper.orm.search.loading.dsl.SearchLoadingOptionsStep;
import org.hibernate.search.mapper.orm.work.SearchWorkspace;
import org.hibernate.search.mapper.orm.work.impl.SearchWorkspaceImpl;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContextBuilder;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexer;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingContext;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeSessionContext;

public class SearchScopeImpl<E>
implements SearchScope<E> {
    private final HibernateOrmScopeMappingContext mappingContext;
    private final PojoScopeDelegate<EntityReference, E, HibernateOrmScopeIndexedTypeContext<? extends E>> delegate;

    public SearchScopeImpl(HibernateOrmScopeMappingContext mappingContext, PojoScopeDelegate<EntityReference, E, HibernateOrmScopeIndexedTypeContext<? extends E>> delegate) {
        this.mappingContext = mappingContext;
        this.delegate = delegate;
    }

    public SearchQuerySelectStep<?, EntityReference, E, SearchLoadingOptionsStep, ?, ?> search(HibernateOrmScopeSessionContext sessionContext, HibernateOrmSelectionLoadingContext.Builder loadingContextBuilder) {
        return this.delegate.search((PojoScopeSessionContext)sessionContext, sessionContext.documentReferenceConverter(), (PojoSelectionLoadingContextBuilder)loadingContextBuilder);
    }

    @Override
    public SearchPredicateFactory predicate() {
        return this.delegate.predicate();
    }

    @Override
    public SearchSortFactory sort() {
        return this.delegate.sort();
    }

    @Override
    public SearchProjectionFactory<EntityReference, E> projection() {
        return this.delegate.projection();
    }

    @Override
    public SearchAggregationFactory aggregation() {
        return this.delegate.aggregation();
    }

    @Override
    public SearchSchemaManager schemaManager() {
        return new SearchSchemaManagerImpl(this.schemaManagerDelegate());
    }

    @Override
    public SearchWorkspace workspace() {
        return this.workspace((String)null);
    }

    @Override
    public SearchWorkspace workspace(String tenantId) {
        return this.workspace(this.mappingContext.detachedBackendSessionContext(tenantId));
    }

    public SearchWorkspace workspace(DetachedBackendSessionContext detachedSessionContext) {
        return new SearchWorkspaceImpl(this.delegate.workspace(detachedSessionContext));
    }

    @Override
    public MassIndexer massIndexer() {
        return this.massIndexer((String)null);
    }

    @Override
    public MassIndexer massIndexer(String tenantId) {
        return this.massIndexer(this.mappingContext.detachedBackendSessionContext(tenantId));
    }

    public MassIndexer massIndexer(DetachedBackendSessionContext detachedSessionContext) {
        HibernateOrmMassIndexingContext massIndexingContext = new HibernateOrmMassIndexingContext(this.mappingContext, this.mappingContext.typeContextProvider(), detachedSessionContext);
        PojoMassIndexer massIndexerDelegate = this.delegate.massIndexer((PojoMassIndexingContext)massIndexingContext, detachedSessionContext);
        return new HibernateOrmMassIndexer(massIndexerDelegate, massIndexingContext);
    }

    @Override
    public Set<? extends SearchIndexedEntity<? extends E>> includedTypes() {
        return this.delegate.includedIndexedTypes();
    }

    @Override
    public <T> T extension(IndexScopeExtension<T> extension) {
        return (T)this.delegate.extension(extension);
    }

    public PojoScopeSchemaManager schemaManagerDelegate() {
        return this.delegate.schemaManager();
    }
}

