/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.data;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.search.util.common.data.RangeBoundInclusion;
import org.hibernate.search.util.common.impl.Contracts;

public final class Range<T> {
    private final Optional<T> lowerBoundValue;
    private final RangeBoundInclusion lowerBoundInclusion;
    private final Optional<T> upperBoundValue;
    private final RangeBoundInclusion upperBoundInclusion;

    public static <T> Range<T> canonical(T lowerBoundValue, T upperBoundValue) {
        return new Range<T>(lowerBoundValue, RangeBoundInclusion.INCLUDED, upperBoundValue, upperBoundValue == null ? RangeBoundInclusion.INCLUDED : RangeBoundInclusion.EXCLUDED);
    }

    public static <T> Range<T> all() {
        return Range.between(null, RangeBoundInclusion.INCLUDED, null, RangeBoundInclusion.INCLUDED);
    }

    public static <T> Range<T> between(T lowerBoundValue, T upperBoundValue) {
        return Range.between(lowerBoundValue, RangeBoundInclusion.INCLUDED, upperBoundValue, RangeBoundInclusion.INCLUDED);
    }

    public static <T> Range<T> between(T lowerBoundValue, RangeBoundInclusion lowerBoundInclusion, T upperBoundValue, RangeBoundInclusion upperBoundInclusion) {
        return new Range<T>(lowerBoundValue, lowerBoundInclusion, upperBoundValue, upperBoundInclusion);
    }

    public static <T> Range<T> atLeast(T lowerBoundValue) {
        Contracts.assertNotNull(lowerBoundValue, "lowerBoundValue");
        return Range.between(lowerBoundValue, RangeBoundInclusion.INCLUDED, null, RangeBoundInclusion.INCLUDED);
    }

    public static <T> Range<T> greaterThan(T lowerBoundValue) {
        Contracts.assertNotNull(lowerBoundValue, "lowerBoundValue");
        return Range.between(lowerBoundValue, RangeBoundInclusion.EXCLUDED, null, RangeBoundInclusion.INCLUDED);
    }

    public static <T> Range<T> atMost(T upperBoundValue) {
        Contracts.assertNotNull(upperBoundValue, "upperBoundValue");
        return Range.between(null, RangeBoundInclusion.INCLUDED, upperBoundValue, RangeBoundInclusion.INCLUDED);
    }

    public static <T> Range<T> lessThan(T upperBoundValue) {
        Contracts.assertNotNull(upperBoundValue, "upperBoundValue");
        return Range.between(null, RangeBoundInclusion.INCLUDED, upperBoundValue, RangeBoundInclusion.EXCLUDED);
    }

    private Range(T lowerBoundValue, RangeBoundInclusion lowerBoundInclusion, T upperBoundValue, RangeBoundInclusion upperBoundInclusion) {
        Contracts.assertNotNull((Object)lowerBoundInclusion, "lowerBoundInclusion");
        Contracts.assertNotNull((Object)upperBoundInclusion, "upperBoundInclusion");
        this.lowerBoundValue = Optional.ofNullable(lowerBoundValue);
        this.lowerBoundInclusion = lowerBoundInclusion;
        this.upperBoundValue = Optional.ofNullable(upperBoundValue);
        this.upperBoundInclusion = upperBoundInclusion;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        switch (this.lowerBoundInclusion) {
            case INCLUDED: {
                builder.append('[');
                break;
            }
            case EXCLUDED: {
                builder.append('(');
            }
        }
        if (this.lowerBoundValue.isPresent()) {
            builder.append(this.lowerBoundValue.get());
        } else {
            builder.append("-Infinity");
        }
        builder.append(",");
        if (this.upperBoundValue.isPresent()) {
            builder.append(this.upperBoundValue.get());
        } else {
            builder.append("+Infinity");
        }
        switch (this.upperBoundInclusion) {
            case INCLUDED: {
                builder.append(']');
                break;
            }
            case EXCLUDED: {
                builder.append(')');
            }
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        return this.lowerBoundValue.equals(other.lowerBoundValue) && this.lowerBoundInclusion == other.lowerBoundInclusion && this.upperBoundValue.equals(other.upperBoundValue) && this.upperBoundInclusion == other.upperBoundInclusion;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lowerBoundValue, this.lowerBoundInclusion, this.upperBoundValue, this.upperBoundInclusion});
    }

    public Optional<T> lowerBoundValue() {
        return this.lowerBoundValue;
    }

    @Deprecated
    public Optional<T> getLowerBoundValue() {
        return this.lowerBoundValue();
    }

    public RangeBoundInclusion lowerBoundInclusion() {
        return this.lowerBoundInclusion;
    }

    @Deprecated
    public RangeBoundInclusion getLowerBoundInclusion() {
        return this.lowerBoundInclusion();
    }

    public Optional<T> upperBoundValue() {
        return this.upperBoundValue;
    }

    @Deprecated
    public Optional<T> getUpperBoundValue() {
        return this.upperBoundValue();
    }

    public RangeBoundInclusion upperBoundInclusion() {
        return this.upperBoundInclusion;
    }

    @Deprecated
    public RangeBoundInclusion getUpperBoundInclusion() {
        return this.upperBoundInclusion();
    }

    public <R> Range<R> map(Function<? super T, ? extends R> function) {
        return Range.between(this.lowerBoundValue.map(function).orElse(null), this.lowerBoundInclusion, this.upperBoundValue.map(function).orElse(null), this.upperBoundInclusion);
    }
}

