/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.reflect.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public final class FieldValueReadHandle<T>
implements ValueReadHandle<T> {
    private static final Log log = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final Field field;

    public FieldValueReadHandle(Field field) {
        this.field = field;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.field + "]";
    }

    @Override
    public T get(Object thiz) {
        try {
            return (T)this.field.get(thiz);
        }
        catch (IllegalAccessException | RuntimeException e) {
            throw log.errorInvokingMember(this.field, Throwables.safeToString(e, thiz), e);
        }
    }

    @Override
    public int hashCode() {
        return this.field.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        FieldValueReadHandle other = (FieldValueReadHandle)obj;
        return this.field.equals(other.field);
    }
}

