/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.jar.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Repeatable;
import java.lang.invoke.MethodHandles;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.jar.impl.JarUtils;
import org.hibernate.search.util.common.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.Type;

public final class JandexUtils {
    private static final Log log = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private static final DotName REPEATABLE = DotName.createSimple((String)Repeatable.class.getName());
    private static final String META_INF_VERSIONS = "META-INF/versions/";
    private static final String META_INF_JANDEX_INDEX = "META-INF/jandex.idx";

    private JandexUtils() {
    }

    public static IndexView emptyIndex() {
        return CompositeIndex.create((IndexView[])new IndexView[0]);
    }

    public static IndexView compositeIndex(Collection<IndexView> jandexIndexes) {
        switch (jandexIndexes.size()) {
            case 0: {
                return JandexUtils.emptyIndex();
            }
            case 1: {
                return jandexIndexes.iterator().next();
            }
        }
        return CompositeIndex.create(jandexIndexes);
    }

    public static Set<DotName> findAnnotatedAnnotationsAndContaining(IndexView index, DotName metaAnnotation) {
        HashSet<DotName> annotations = new HashSet<DotName>();
        for (AnnotationInstance retentionAnnotation : index.getAnnotations(metaAnnotation)) {
            ClassInfo annotation = retentionAnnotation.target().asClass();
            annotations.add(annotation.name());
            AnnotationInstance repeatable = annotation.classAnnotation(REPEATABLE);
            if (repeatable == null) continue;
            Type containing = repeatable.value().asClass();
            annotations.add(containing.name());
        }
        return annotations;
    }

    public static ClassInfo extractDeclaringClass(AnnotationTarget target) {
        switch (target.kind()) {
            case CLASS: {
                return target.asClass();
            }
            case FIELD: {
                return target.asField().declaringClass();
            }
            case METHOD: {
                return target.asMethod().declaringClass();
            }
            case METHOD_PARAMETER: {
                return target.asMethodParameter().method().declaringClass();
            }
            case TYPE: {
                return JandexUtils.extractDeclaringClass(target.asType().enclosingTarget());
            }
        }
        throw new AssertionFailure("Unsupported annotation target kind: " + target.kind());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Index readOrBuildIndex(Path jarOrDirectoryPath) {
        try (FileSystem jarFs = JarUtils.openJarOrDirectory(jarOrDirectoryPath);){
            Path jarRoot = jarFs == null ? jarOrDirectoryPath : jarFs.getRootDirectories().iterator().next();
            Optional<Index> readIndex = JandexUtils.doReadIndex(jarRoot);
            if (readIndex.isPresent()) {
                Index index = readIndex.get();
                return index;
            }
            Index index = JandexUtils.doBuildJandexIndex(jarRoot);
            return index;
        }
        catch (IOException | RuntimeException | URISyntaxException e) {
            throw log.errorAccessingJandexIndex(jarOrDirectoryPath, e.getMessage(), e);
        }
    }

    public static Optional<Index> readIndex(Path jarOrDirectoryPath) {
        Optional<Index> optional;
        block8: {
            FileSystem jarFs = JarUtils.openJarOrDirectory(jarOrDirectoryPath);
            try {
                Path jarRoot = jarFs == null ? jarOrDirectoryPath : jarFs.getRootDirectories().iterator().next();
                optional = JandexUtils.doReadIndex(jarRoot);
                if (jarFs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jarFs != null) {
                        try {
                            jarFs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException | URISyntaxException e) {
                    throw log.errorAccessingJandexIndex(jarOrDirectoryPath, e.getMessage(), e);
                }
            }
            jarFs.close();
        }
        return optional;
    }

    private static Optional<Index> doReadIndex(Path jarRoot) throws IOException {
        Path jandexIndexPath = jarRoot.resolve(META_INF_JANDEX_INDEX);
        if (!Files.exists(jandexIndexPath, new LinkOption[0])) {
            return Optional.empty();
        }
        try (InputStream in = Files.newInputStream(jandexIndexPath, new OpenOption[0]);){
            IndexReader reader = new IndexReader(in);
            Optional<Index> optional = Optional.of(reader.read());
            return optional;
        }
    }

    private static Index doBuildJandexIndex(Path jarRoot) throws IOException {
        Indexer indexer = new Indexer();
        boolean multiRelease = JarUtils.isMultiRelease(jarRoot);
        Path metaInfVersions = jarRoot.resolve(META_INF_VERSIONS);
        try (Stream<Path> stream = Files.walk(jarRoot, new FileVisitOption[0]);){
            Iterator it = stream.iterator();
            while (it.hasNext()) {
                Path path = (Path)it.next();
                if (path.getFileName() == null || !path.getFileName().toString().endsWith(".class") || multiRelease && path.startsWith(metaInfVersions) && JandexUtils.isUnsupportedVersionPath(metaInfVersions, path)) continue;
                InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                try {
                    indexer.index(inputStream);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        return indexer.complete();
    }

    private static boolean isUnsupportedVersionPath(Path metaInfVersions, Path path) {
        Path relative = metaInfVersions.relativize(path);
        if (relative.getNameCount() < 2) {
            log.debug("Unexpected structure for META-INF/versions entry: " + path);
            return true;
        }
        try {
            int ver = Integer.parseInt(relative.getName(0).toString());
            if (ver > JarUtils.javaVersion()) {
                return true;
            }
        }
        catch (NumberFormatException ex) {
            log.debug("Failed to parse META-INF/versions entry: " + path, ex);
            return true;
        }
        return false;
    }
}

