/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.jar.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Manifest;
import org.hibernate.search.util.common.AssertionFailure;

public final class JarUtils {
    private static final String META_INF_MANIFEST = "META-INF/MANIFEST.MF";
    private static final int JAVA_VERSION;

    private JarUtils() {
    }

    public static int javaVersion() {
        return JAVA_VERSION;
    }

    public static Optional<Path> jarOrDirectoryPath(Class<?> classFromJar) {
        CodeSource codeSource = classFromJar.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return Optional.empty();
        }
        URL url = codeSource.getLocation();
        if (url == null || !url.getProtocol().equals("file")) {
            return Optional.empty();
        }
        try {
            Path path = Paths.get(url.toURI());
            return Optional.of(path);
        }
        catch (URISyntaxException e) {
            throw new AssertionFailure("Unexpected failure while accessing JAR", e);
        }
    }

    public static FileSystem openJarOrDirectory(Path jarOrDirectoryPath) throws IOException, URISyntaxException {
        if (Files.isDirectory(jarOrDirectoryPath, new LinkOption[0])) {
            return null;
        }
        URI jarUri = new URI("jar:file", null, jarOrDirectoryPath.toUri().getPath(), null);
        Map zipFsEnv = Collections.emptyMap();
        return FileSystems.newFileSystem(jarUri, zipFsEnv);
    }

    static boolean isMultiRelease(Path jarRoot) {
        String value;
        Path manifestPath = jarRoot.resolve(META_INF_MANIFEST);
        if (!Files.exists(manifestPath, new LinkOption[0])) {
            return false;
        }
        try {
            Manifest manifest = new Manifest(Files.newInputStream(manifestPath, new OpenOption[0]));
            value = manifest.getMainAttributes().getValue("Multi-Release");
        }
        catch (IOException var3) {
            throw new UncheckedIOException("Cannot read manifest attributes", var3);
        }
        return Boolean.parseBoolean(value);
    }

    static {
        int version = 8;
        try {
            Method versionMethod = Runtime.class.getMethod("version", new Class[0]);
            Object v = versionMethod.invoke(null, new Object[0]);
            List list = (List)v.getClass().getMethod("version", new Class[0]).invoke(v, new Object[0]);
            version = (Integer)list.get(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JAVA_VERSION = version;
    }
}

