/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.data.impl;

import java.util.Arrays;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.impl.HashTable;
import org.hibernate.search.util.common.data.impl.RangeCompatibleHashFunction;

public final class RangeHashTable<T>
extends HashTable<T> {
    private final RangeCompatibleHashFunction hashFunction;
    private final Range<Integer>[] bucketRanges;
    private final int[] lowerBounds;

    public RangeHashTable(RangeCompatibleHashFunction hashFunction, int size) {
        super(size);
        this.hashFunction = hashFunction;
        this.bucketRanges = new Range[size];
        if (size == 1) {
            this.bucketRanges[0] = Range.all();
        } else {
            long integerSpaceWidth = 0x100000000L;
            int rangeWidth = (int)(integerSpaceWidth / (long)size);
            int upperBound = Integer.MIN_VALUE + rangeWidth;
            this.bucketRanges[0] = Range.lessThan(Integer.MIN_VALUE + rangeWidth);
            for (int i = 1; i < size - 1; ++i) {
                int lowerBound = upperBound;
                upperBound = lowerBound + rangeWidth;
                this.bucketRanges[i] = Range.canonical(lowerBound, upperBound);
            }
            int lowerBound = upperBound;
            this.bucketRanges[size - 1] = Range.atLeast(lowerBound);
        }
        this.lowerBounds = new int[size];
        for (int i = 0; i < size; ++i) {
            this.lowerBounds[i] = this.bucketRanges[i].lowerBoundValue().orElse(Integer.MIN_VALUE);
        }
    }

    @Override
    public int computeIndex(CharSequence key) {
        return this.computeIndexForHash(this.hashFunction.hash(key));
    }

    public int computeIndexForHash(int hash) {
        int searchResult = Arrays.binarySearch(this.lowerBounds, hash);
        return searchResult >= 0 ? searchResult : -(searchResult + 2);
    }

    public Range<Integer> rangeForBucket(int index) {
        return this.bucketRanges[index];
    }
}

