/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.data.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.hibernate.search.util.common.SearchException;

public final class KeyValueProvider<K, V> {
    private final Map<K, ? extends V> content;
    private final BiFunction<? super K, ? super Set<K>, SearchException> missingValueExceptionFactory;

    public KeyValueProvider(Map<K, ? extends V> content, BiFunction<? super K, ? super Set<K>, SearchException> missingValueExceptionFactory) {
        this.content = Collections.unmodifiableMap(content);
        this.missingValueExceptionFactory = missingValueExceptionFactory;
    }

    public V getOrFail(K key) {
        V result = this.content.get(key);
        if (result == null) {
            throw this.missingValueExceptionFactory.apply(key, this.content.keySet());
        }
        return result;
    }

    public Optional<V> getOptional(K key) {
        return Optional.ofNullable(this.content.get(key));
    }

    public V getOrNull(K key) {
        return this.content.get(key);
    }

    public Collection<? extends V> values() {
        return this.content.values();
    }
}

