/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.reflect.impl;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.CommonMiscLog;
import org.hibernate.search.util.common.reflect.impl.ReflectionUtils;

public final class GenericTypeContext {
    private final Type resolvedType;
    private final GenericTypeContext declaringContext;
    private final Map<TypeVariable<?>, Type> typeMappings;

    public GenericTypeContext(Type type) {
        this(null, null, type);
    }

    public GenericTypeContext(GenericTypeContext declaringContext, Type type) {
        this(declaringContext, null, type);
    }

    public GenericTypeContext(GenericTypeContext declaringContext, GenericTypeContext castBase, Type type) {
        Contracts.assertNotNull(type, "type");
        this.resolvedType = declaringContext != null ? declaringContext.resolveType(type) : type;
        this.declaringContext = declaringContext;
        this.typeMappings = new HashMap();
        GenericTypeContext.populateTypeMappings(this.typeMappings, this.resolvedType);
        if (castBase != null) {
            GenericTypeContext.inferTypeMappingsFromCastBase(this.typeMappings, castBase);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.resolvedType.getTypeName() + ", " + String.valueOf(this.declaringContext) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericTypeContext that = (GenericTypeContext)o;
        return Objects.equals(this.resolvedType, that.resolvedType) && Objects.equals(this.declaringContext, that.declaringContext);
    }

    public int hashCode() {
        return Objects.hash(this.resolvedType, this.declaringContext);
    }

    public Class<?> rawType() {
        return ReflectionUtils.getRawType(this.resolvedType);
    }

    public String name() {
        Class<?> rawType = this.rawType();
        StringBuilder builder = new StringBuilder(rawType.getTypeName());
        TypeVariable<Class<?>>[] typeParameters = rawType.getTypeParameters();
        if (typeParameters.length > 0) {
            builder.append('<');
            for (int i = 0; i < typeParameters.length; ++i) {
                if (i > 0) {
                    builder.append(',');
                }
                builder.append(((Type)this.resolveTypeArgument(rawType, i).orElse(typeParameters[i])).getTypeName());
            }
            builder.append('>');
        }
        if (this.resolvedType.getTypeName().equals(builder.toString())) {
            return this.resolvedType.getTypeName();
        }
        builder.insert(0, this.resolvedType.getTypeName() + " (");
        builder.append(")");
        return builder.toString();
    }

    public GenericTypeContext declaringContext() {
        return this.declaringContext;
    }

    public GenericTypeContext castTo(Class<?> target) {
        return new GenericTypeContext(this.declaringContext, this, target);
    }

    public Optional<Type> resolveTypeArgument(Class<?> rawSuperType, int typeParameterIndex) {
        TypeVariable<Class<?>>[] typeParameters = rawSuperType.getTypeParameters();
        int typeParametersLength = typeParameters.length;
        if (typeParametersLength == 0) {
            throw CommonMiscLog.INSTANCE.cannotRequestTypeParameterOfUnparameterizedType(this.resolvedType, rawSuperType, typeParameterIndex);
        }
        if (typeParametersLength <= typeParameterIndex) {
            throw CommonMiscLog.INSTANCE.typeParameterIndexOutOfBound(this.resolvedType, rawSuperType, typeParameterIndex, typeParametersLength);
        }
        if (typeParameterIndex < 0) {
            throw CommonMiscLog.INSTANCE.invalidTypeParameterIndex(this.resolvedType, rawSuperType, typeParameterIndex);
        }
        TypeVariable<Class<?>> typeVariable = typeParameters[typeParameterIndex];
        if (!this.typeMappings.containsKey(typeVariable)) {
            return Optional.empty();
        }
        return Optional.of(this.resolveType(typeVariable));
    }

    public Optional<Type> resolveArrayElementType() {
        return ReflectionUtils.getArrayElementType(this.resolvedType).map(this::resolveType);
    }

    private Type resolveType(Type type) {
        Type result = type;
        TypeVariable typeVariable = null;
        while (result instanceof TypeVariable && result != typeVariable) {
            typeVariable = (TypeVariable)result;
            if (typeVariable.getGenericDeclaration() instanceof Class) {
                result = this.typeMappings.get(typeVariable);
                continue;
            }
            result = typeVariable.getBounds()[0];
        }
        if (result == null && typeVariable != null) {
            if (this.declaringContext != null) {
                return this.declaringContext.resolveType(typeVariable);
            }
            return typeVariable;
        }
        return result;
    }

    private static void populateTypeMappings(Map<TypeVariable<?>, Type> mappings, Type type) {
        if (type instanceof TypeVariable) {
            for (Type upperBound : ((TypeVariable)type).getBounds()) {
                GenericTypeContext.populateTypeMappings(mappings, upperBound);
            }
        } else if (type instanceof WildcardType) {
            for (Type upperBound : ((WildcardType)type).getUpperBounds()) {
                GenericTypeContext.populateTypeMappings(mappings, upperBound);
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class<?> rawType = ReflectionUtils.getRawType(parameterizedType);
            TypeVariable<Class<?>>[] typeParameters = rawType.getTypeParameters();
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                mappings.put(typeParameters[i], typeArguments[i]);
            }
            GenericTypeContext.populateTypeMappings(mappings, rawType);
        } else if (type instanceof Class) {
            Class clazz = (Class)type;
            for (TypeVariable typeParameter : clazz.getTypeParameters()) {
                mappings.putIfAbsent(typeParameter, typeParameter);
            }
            for (Type interfaze : clazz.getGenericInterfaces()) {
                GenericTypeContext.populateTypeMappings(mappings, interfaze);
            }
            Type superClass = clazz.getGenericSuperclass();
            if (superClass != null) {
                GenericTypeContext.populateTypeMappings(mappings, superClass);
            }
        } else if (!(type instanceof GenericArrayType)) {
            throw new AssertionFailure("Unexpected java.lang.reflect.Type type: " + String.valueOf(type.getClass()));
        }
    }

    private static void inferTypeMappingsFromCastBase(Map<TypeVariable<?>, Type> typeMappings, GenericTypeContext castBase) {
        for (Map.Entry<TypeVariable<?>, Type> baseMapping : castBase.typeMappings.entrySet()) {
            Type baseVariableValueInThis;
            TypeVariable<?> baseVariable = baseMapping.getKey();
            Type baseVariableValue = castBase.resolveType(baseVariable);
            if (baseVariableValue instanceof TypeVariable || !((baseVariableValueInThis = typeMappings.get(baseVariable)) instanceof TypeVariable)) continue;
            TypeVariable subTypeVariable = (TypeVariable)baseVariableValueInThis;
            Type subTypeVariableValueInThis = typeMappings.get(subTypeVariable);
            while (subTypeVariableValueInThis instanceof TypeVariable && !subTypeVariable.equals(subTypeVariableValueInThis)) {
                subTypeVariable = (TypeVariable)subTypeVariableValueInThis;
                subTypeVariableValueInThis = typeMappings.get(subTypeVariable);
            }
            if (!subTypeVariable.equals(subTypeVariableValueInThis)) continue;
            typeMappings.put(subTypeVariable, baseVariableValue);
        }
    }
}

