/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.reflect.spi;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.hibernate.search.util.common.logging.impl.CommonMiscLog;
import org.hibernate.search.util.common.reflect.spi.ValueHandleFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public final class AnnotationHelper {
    private final ValueHandleFactory handleFactory;
    private final Map<Class<? extends Annotation>, ValueReadHandle<Annotation[]>> containedAnnotationsHandleCache = new HashMap<Class<? extends Annotation>, ValueReadHandle<Annotation[]>>();

    public AnnotationHelper(ValueHandleFactory handleFactory) {
        this.handleFactory = handleFactory;
    }

    public Stream<? extends Annotation> expandRepeatableContainingAnnotation(Annotation containingAnnotationCandidate) {
        Class<? extends Annotation> containingAnnotationCandidateType = containingAnnotationCandidate.annotationType();
        ValueReadHandle containedAnnotationsHandle = this.containedAnnotationsHandleCache.computeIfAbsent(containingAnnotationCandidateType, this::createContainedAnnotationsHandle);
        if (containedAnnotationsHandle != null) {
            try {
                Annotation[] annotationArray = (Annotation[])containedAnnotationsHandle.get(containingAnnotationCandidate);
                return Arrays.stream(annotationArray);
            }
            catch (Throwable e) {
                CommonMiscLog.INSTANCE.cannotAccessRepeateableContainingAnnotationValue(containingAnnotationCandidateType, e);
            }
        }
        return Stream.of(containingAnnotationCandidate);
    }

    private ValueReadHandle<Annotation[]> createContainedAnnotationsHandle(Class<? extends Annotation> containingAnnotationCandidateType) {
        Repeatable repeatable;
        Class<?> elementType;
        Method valueMethod;
        try {
            valueMethod = containingAnnotationCandidateType.getDeclaredMethod("value", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        Class<?> valueMethodReturnType = valueMethod.getReturnType();
        if (valueMethodReturnType.isArray() && Annotation.class.isAssignableFrom(elementType = valueMethodReturnType.getComponentType()) && (repeatable = elementType.getAnnotation(Repeatable.class)) != null && containingAnnotationCandidateType.equals(repeatable.value())) {
            try {
                ValueReadHandle<Annotation[]> result = this.handleFactory.createForMethod(valueMethod);
                return result;
            }
            catch (IllegalAccessException e) {
                CommonMiscLog.INSTANCE.cannotAccessRepeateableContainingAnnotationValue(containingAnnotationCandidateType, e);
            }
        }
        return null;
    }
}

