/*
 * Decompiled with CFR 0.152.
 */
package org.hibersap.execution.jco;

import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibersap.HibersapException;

public class JCoDataProvider
implements DestinationDataProvider {
    private static final Log LOG = LogFactory.getLog(JCoDataProvider.class);
    private final Map<String, Properties> propertiesForDestinationName = new HashMap<String, Properties>();
    private DestinationDataEventListener eventListener;

    public void addDestination(String destinationName, Properties properties) {
        LOG.debug((Object)("Add destination " + destinationName + " to " + this.propertiesForDestinationName));
        this.propertiesForDestinationName.put(destinationName, properties);
        this.fireDestinationUpdatedEvent(destinationName);
    }

    public void removeDestination(String destinationName) {
        LOG.debug((Object)("Remove destination " + destinationName + " from " + this.propertiesForDestinationName));
        this.propertiesForDestinationName.remove(destinationName);
        this.fireDestinationDeletedEvent(destinationName);
    }

    public Properties getDestinationProperties(String destinationName) {
        if (this.wasAdded(destinationName)) {
            return this.propertiesForDestinationName.get(destinationName);
        }
        throw new HibersapException("No JCo destination with name " + destinationName + " found");
    }

    public boolean wasAdded(String destinationName) {
        return this.propertiesForDestinationName.containsKey(destinationName);
    }

    public boolean hasDestinations() {
        return !this.propertiesForDestinationName.isEmpty();
    }

    public void setDestinationDataEventListener(DestinationDataEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public boolean supportsEvents() {
        return true;
    }

    private void fireDestinationUpdatedEvent(String destinationName) {
        if (this.eventListener != null) {
            this.eventListener.updated(destinationName);
        }
    }

    private void fireDestinationDeletedEvent(String destinationName) {
        if (this.eventListener != null) {
            this.eventListener.deleted(destinationName);
        }
    }
}

