/*
 * Decompiled with CFR 0.152.
 */
package org.hibersap.generation.bapi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibersap.InternalHiberSapException;
import org.hibersap.annotations.Bapi;
import org.hibersap.annotations.BapiStructure;
import org.hibersap.annotations.Export;
import org.hibersap.annotations.Import;
import org.hibersap.annotations.Parameter;
import org.hibersap.annotations.ParameterType;
import org.hibersap.annotations.Table;
import org.hibersap.generation.bapi.BapiFormatHelper;
import org.hibersap.mapping.model.BapiMapping;
import org.hibersap.mapping.model.ParameterMapping;
import org.hibersap.mapping.model.StructureMapping;
import org.hibersap.mapping.model.TableMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BapiClassFormatter {
    private static final String CLASS_FORMAT = "package %s;%n%n%s%npublic class %s%n{%n%s}";
    private static final String BAPI_FIELD_FORMAT = "\t%s%n\t%s%n\tprivate %s %s;%n%n";
    private static final String STRUCTURE_FIELD_FORMAT = "\t%s%n\tprivate %s %s;%n%n";
    private static final String GETTER_FORMAT = "\tpublic %s get%s()%n\t{%n\t\treturn %s;%n\t}%n%n";
    private static final String SETTER_FORMAT = "\tpublic void set%s(%s %s)%n\t{%n\t\tthis.%s = %s;%n\t}%n%n";
    private static final String PARAMETER_ANNOTATION_SIMPLE_FORMAT = "@%s(\"%s\")";
    private static final String PARAMETER_ANNOTATION_STRUCTURE_FORMAT = "@%s(value = \"%s\", type = %s.%s)";
    private static final String TYPE_ANNOTATION_FORMAT = "@%s";
    private static final String BAPI_ANNOTATION_FORMAT = "@%s(\"%s\")";
    private static final String BAPI_STRUCTURE_ANNOTATION_FORMAT = "@%s";

    private void checkPackagePath(String packagePath) {
    }

    public Map<String, String> createClasses(BapiMapping mapping, String packagePath) {
        this.checkPackagePath(packagePath);
        HashMap<String, String> result = new HashMap<String, String>();
        String bapiClassName = BapiFormatHelper.getCamelCaseBig(mapping.getBapiName());
        String bapiClass = this.formatBapiClass(mapping, packagePath);
        result.put(bapiClassName, bapiClass);
        result.putAll(this.formatStructureClasses(mapping, packagePath));
        return result;
    }

    private Map<String, String> formatStructureClasses(BapiMapping mapping, String packagePath) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashSet params = new HashSet();
        params.addAll(mapping.getImportParameters());
        params.addAll(mapping.getExportParameters());
        params.addAll(mapping.getTableParameters());
        for (ParameterMapping param : params) {
            if (param.getParamType() == ParameterMapping.ParamType.FIELD) continue;
            String className = BapiFormatHelper.getCamelCaseBig(param.getSapName());
            String structureClass = this.formatStructureClass(param, packagePath);
            result.put(className, structureClass);
        }
        return result;
    }

    private String formatStructureClass(ParameterMapping param, String packagePath) {
        StructureMapping structure;
        if (param instanceof StructureMapping) {
            structure = (StructureMapping)param;
        } else if (param instanceof TableMapping) {
            structure = ((TableMapping)param).getComponentParameter();
        } else {
            throw new InternalHiberSapException("This exception should not occur, please report to Hibersap developers. Not supported: " + param.getClass());
        }
        String structureAnnotation = String.format("@%s", BapiStructure.class.getName());
        String className = BapiFormatHelper.getCamelCaseBig(param.getSapName());
        String fieldsAndMethods = this.formatFieldsAndMethods(structure);
        return String.format(CLASS_FORMAT, packagePath, structureAnnotation, className, fieldsAndMethods);
    }

    private String formatBapiAnnotation(BapiMapping mapping) {
        return String.format("@%s(\"%s\")", Bapi.class.getName(), mapping.getBapiName());
    }

    private String formatBapiClass(BapiMapping mapping, String packagePath) {
        return String.format(CLASS_FORMAT, packagePath, this.formatBapiAnnotation(mapping), this.getBapiName(mapping), this.formatFieldsAndMethods(mapping));
    }

    private String formatField(String sapName, String javaName, String javaType, Class<?> typeAnnotation, ParameterMapping.ParamType paramType) {
        String parameter = this.formatParameterAnnotation(sapName, paramType);
        if (typeAnnotation != null) {
            String type = String.format("@%s", typeAnnotation.getName());
            return String.format(BAPI_FIELD_FORMAT, type, parameter, javaType, javaName);
        }
        return String.format(STRUCTURE_FIELD_FORMAT, parameter, javaType, javaName);
    }

    private String formatFieldsAndMethods(BapiMapping bapiMapping) {
        StringBuilder fields = new StringBuilder();
        StringBuilder methods = new StringBuilder();
        this.formatFieldsAndMethods(bapiMapping.getImportParameters(), fields, methods, Import.class);
        this.formatFieldsAndMethods(bapiMapping.getExportParameters(), fields, methods, Export.class);
        this.formatFieldsAndMethods(bapiMapping.getTableParameters(), fields, methods, Table.class);
        return fields.toString() + methods.toString();
    }

    private String formatFieldsAndMethods(StructureMapping mapping) {
        StringBuilder fields = new StringBuilder();
        StringBuilder methods = new StringBuilder();
        this.formatFieldsAndMethods(mapping.getParameters(), fields, methods, null);
        return fields.toString() + methods.toString();
    }

    private void formatFieldsAndMethods(Set<? extends ParameterMapping> params, StringBuilder fields, StringBuilder methods, Class<?> annotation) {
        for (ParameterMapping parameterMapping : params) {
            String sapName = parameterMapping.getSapName();
            String javaName = parameterMapping.getJavaName();
            String javaType = this.getClassName(parameterMapping);
            String field = this.formatField(sapName, javaName, javaType, annotation, parameterMapping.getParamType());
            fields.append(field);
            String getterAndSetter = this.formatMethods(sapName, javaName, javaType);
            methods.append(getterAndSetter);
        }
    }

    private String formatMethods(String sapName, String javaName, String javaType) {
        String getter = String.format(GETTER_FORMAT, javaType, BapiFormatHelper.getCamelCaseBig(sapName), javaName);
        String setter = String.format(SETTER_FORMAT, BapiFormatHelper.getCamelCaseBig(sapName), javaType, javaName, javaName, javaName);
        return getter + setter;
    }

    private String formatParameterAnnotation(String sapName, ParameterMapping.ParamType paramType) {
        if (paramType == ParameterMapping.ParamType.STRUCTURE) {
            return String.format(PARAMETER_ANNOTATION_STRUCTURE_FORMAT, Parameter.class.getName(), sapName, ParameterType.class.getName(), ParameterType.STRUCTURE);
        }
        return String.format("@%s(\"%s\")", Parameter.class.getName(), sapName);
    }

    private String getBapiName(BapiMapping mapping) {
        return BapiFormatHelper.getCamelCaseBig(mapping.getBapiName());
    }

    private String getClassName(ParameterMapping param) {
        if (param.getParamType() == ParameterMapping.ParamType.FIELD) {
            return param.getAssociatedType().getName();
        }
        String className = BapiFormatHelper.getCamelCaseBig(param.getSapName());
        if (param.getParamType() == ParameterMapping.ParamType.STRUCTURE) {
            return className;
        }
        return List.class.getName() + "<" + className + ">";
    }
}

