/*
 * Decompiled with CFR 0.152.
 */
package org.hibersap.execution.jco;

import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibersap.HibersapException;
import org.hibersap.configuration.xml.Property;
import org.hibersap.configuration.xml.SessionManagerConfig;
import org.hibersap.execution.Connection;
import org.hibersap.execution.jco.JCoConnection;
import org.hibersap.execution.jco.JCoEnvironment;
import org.hibersap.session.Context;

public class JCoContext
implements Context {
    private static final Log LOG = LogFactory.getLog(JCoContext.class);
    private static final String JCO_PROPERTIES_PREFIX = "jco.";
    private String destinationName;

    public void configure(SessionManagerConfig config) {
        LOG.trace((Object)"configure JCo context");
        Properties jcoProperties = new Properties();
        List properties = config.getProperties();
        for (Property property : properties) {
            String name = property.getName();
            if (!name.startsWith(JCO_PROPERTIES_PREFIX)) continue;
            jcoProperties.put(name, property.getValue());
        }
        this.destinationName = config.getName();
        if (StringUtils.isEmpty((String)this.destinationName)) {
            throw new HibersapException("A session manager name must be specified in Hibersap configuration");
        }
        JCoEnvironment.registerDestination(this.destinationName, jcoProperties);
    }

    public void close() {
        JCoEnvironment.unregisterDestination(this.destinationName);
        this.destinationName = null;
    }

    public Connection getConnection() {
        return new JCoConnection(this.destinationName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destinationName == null ? 0 : this.destinationName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JCoContext other = (JCoContext)obj;
        return !(this.destinationName == null ? other.destinationName != null : !this.destinationName.equals(other.destinationName));
    }
}

