/*
 * Decompiled with CFR 0.152.
 */
package org.hibersap.execution.jco;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibersap.HibersapException;
import org.hibersap.execution.jco.JCoDataProvider;

public final class JCoEnvironment {
    private static final Log LOG = LogFactory.getLog(JCoEnvironment.class);
    private static final JCoDataProvider destinationDataProvider = new JCoDataProvider();

    private JCoEnvironment() {
    }

    public static void registerDestination(String destinationName, Properties jcoProperties) {
        LOG.info((Object)("Registering destination " + destinationName));
        if (!destinationDataProvider.hasDestinations()) {
            JCoEnvironment.registerDestinationDataProvider();
        }
        destinationDataProvider.addDestination(destinationName, jcoProperties);
    }

    public static void unregisterDestination(String destinationName) {
        LOG.info((Object)("Unregistering destination " + destinationName));
        destinationDataProvider.removeDestination(destinationName);
        if (!destinationDataProvider.hasDestinations()) {
            JCoEnvironment.unregisterDestinationDataProvider();
        }
    }

    public static JCoDestination getDestination(String destinationName) {
        try {
            return JCoDestinationManager.getDestination((String)destinationName);
        }
        catch (JCoException e) {
            throw new HibersapException("Destination named '" + destinationName + "' is not registered with JCo", (Throwable)e);
        }
    }

    private static void registerDestinationDataProvider() {
        LOG.info((Object)"Registering DestinationDataProvider with JCo");
        Environment.registerDestinationDataProvider((DestinationDataProvider)destinationDataProvider);
    }

    private static void unregisterDestinationDataProvider() {
        LOG.info((Object)"Unregistering DestinationDataProvider from JCo");
        Environment.unregisterDestinationDataProvider((DestinationDataProvider)destinationDataProvider);
    }

    static {
        LOG.info((Object)("Using SAP JCo - java.library.path=" + SystemUtils.JAVA_LIBRARY_PATH));
    }
}

