/*
 * Decompiled with CFR 0.152.
 */
package org.hibersap.execution.jco;

import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFieldIterator;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibersap.HibersapException;
import org.hibersap.execution.UnsafeCastHelper;

public class JCoMapper {
    private static final Log LOG = LogFactory.getLog(JCoMapper.class);

    void putFunctionMapValuesToFunction(JCoFunction function, Map<String, Object> functionMap) {
        Map importMap = UnsafeCastHelper.castToMap((Object)functionMap.get("IMPORT"));
        this.mapToJCo((JCoRecord)function.getImportParameterList(), importMap);
        Map exportMap = UnsafeCastHelper.castToMap((Object)functionMap.get("EXPORT"));
        this.mapToJCo((JCoRecord)function.getExportParameterList(), exportMap);
        Map changingMap = UnsafeCastHelper.castToMap((Object)functionMap.get("CHANGING"));
        this.mapToJCo((JCoRecord)function.getChangingParameterList(), changingMap);
        Map tableMap = UnsafeCastHelper.castToMap((Object)functionMap.get("TABLE"));
        this.mapToJCo((JCoRecord)function.getTableParameterList(), tableMap);
    }

    void putFunctionValuesToFunctionMap(JCoFunction function, Map<String, Object> map) {
        map.put("IMPORT", this.mapToMap((JCoRecord)function.getImportParameterList()));
        map.put("EXPORT", this.mapToMap((JCoRecord)function.getExportParameterList()));
        map.put("CHANGING", this.mapToMap((JCoRecord)function.getChangingParameterList()));
        map.put("TABLE", this.mapToMap((JCoRecord)function.getTableParameterList()));
    }

    private void checkTypes(Object value, String classNameOfBapiField, String fieldName) {
        block3: {
            try {
                if (value != null && !Class.forName(classNameOfBapiField).isAssignableFrom(value.getClass())) {
                    throw new HibersapException("JCo field " + fieldName + " has type " + classNameOfBapiField + " while value to set has type " + value.getClass().getName());
                }
            }
            catch (ClassNotFoundException e) {
                if (classNameOfBapiField.equals(byte[].class.getCanonicalName())) break block3;
                LOG.warn((Object)("Class check of JCo field failed, class " + classNameOfBapiField + " not found"));
            }
        }
    }

    private void mapToJCo(JCoRecord jCoRecord, Map<String, Object> map) {
        for (String fieldName : map.keySet()) {
            Object value = map.get(fieldName);
            if (Map.class.isAssignableFrom(value.getClass())) {
                Map structureMap = UnsafeCastHelper.castToMap((Object)value);
                JCoStructure structure = jCoRecord.getStructure(fieldName);
                this.mapToJCo((JCoRecord)structure, structureMap);
                continue;
            }
            if (Collection.class.isAssignableFrom(value.getClass())) {
                Collection tableMap = UnsafeCastHelper.castToCollectionOfMaps((Object)value);
                JCoTable table = jCoRecord.getTable(fieldName);
                table.clear();
                for (Map structureMap : tableMap) {
                    table.appendRow();
                    this.mapToJCo((JCoRecord)table, structureMap);
                }
                continue;
            }
            this.checkTypes(value, jCoRecord.getClassNameOfValue(fieldName), fieldName);
            jCoRecord.setValue(fieldName, value);
        }
    }

    private Map<String, Object> mapToMap(JCoRecord jCoRecord) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (jCoRecord == null) {
            return map;
        }
        JCoFieldIterator iter = jCoRecord.getFieldIterator();
        while (iter.hasNextField()) {
            JCoField jcoField = iter.nextField();
            String sapFieldName = jcoField.getName();
            if (jcoField.isStructure()) {
                map.put(sapFieldName, this.mapToMap((JCoRecord)jcoField.getStructure()));
                continue;
            }
            if (jcoField.isTable()) {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                JCoTable table = jcoField.getTable();
                for (int j = 0; j < table.getNumRows(); ++j) {
                    table.setRow(j);
                    list.add(this.mapToMap((JCoRecord)table));
                }
                map.put(sapFieldName, list);
                continue;
            }
            Object value = jcoField.getValue();
            map.put(sapFieldName, value);
        }
        return map;
    }
}

