/*
 * Decompiled with CFR 0.152.
 */
package org.hibersap.generation.bapi;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFieldIterator;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoParameterFieldIterator;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecord;
import java.util.List;
import java.util.Set;
import org.hibersap.HibersapException;
import org.hibersap.InternalHiberSapException;
import org.hibersap.generation.bapi.BapiFormatHelper;
import org.hibersap.mapping.model.BapiMapping;
import org.hibersap.mapping.model.FieldMapping;
import org.hibersap.mapping.model.ParameterMapping;
import org.hibersap.mapping.model.StructureMapping;
import org.hibersap.mapping.model.TableMapping;
import org.hibersap.session.SessionManager;

public class ReverseBapiMapper {
    public BapiMapping map(String bapiName, SessionManager sessionManager) {
        try {
            String sfName = sessionManager.getConfig().getName();
            JCoDestination destination = JCoDestinationManager.getDestination((String)sfName);
            JCoFunctionTemplate ft = destination.getRepository().getFunctionTemplate(bapiName);
            JCoFunction function = ft.getFunction();
            BapiMapping mapping = new BapiMapping(null, function.getName(), null);
            this.mapFields(mapping.getImportParameters(), function.getImportParameterList());
            this.mapFields(mapping.getExportParameters(), function.getExportParameterList());
            this.mapFields(mapping.getChangingParameters(), function.getChangingParameterList());
            this.mapFields(mapping.getTableParameters(), function.getTableParameterList());
            return mapping;
        }
        catch (JCoException e) {
            throw new HibersapException((Throwable)e);
        }
    }

    private void mapFields(Set<? extends ParameterMapping> set, JCoParameterList jcoParams) {
        if (jcoParams == null) {
            return;
        }
        JCoParameterFieldIterator iter = jcoParams.getParameterFieldIterator();
        while (iter.hasNextField()) {
            JCoField field = iter.nextField();
            ParameterMapping param = this.getParameterMapping(field);
            if (ParameterMapping.ParamType.FIELD == param.getParamType()) {
                set.add((ParameterMapping)((FieldMapping)param));
                continue;
            }
            if (ParameterMapping.ParamType.STRUCTURE == param.getParamType()) {
                set.add((ParameterMapping)((StructureMapping)param));
                continue;
            }
            if (ParameterMapping.ParamType.TABLE != param.getParamType()) continue;
            set.add((ParameterMapping)((TableMapping)param));
        }
    }

    private ParameterMapping getParameterMapping(JCoField field) {
        String javaFieldName = BapiFormatHelper.getCamelCaseSmall(field.getName());
        if (field.isStructure()) {
            StructureMapping structureMapping = new StructureMapping(null, field.getName(), javaFieldName, null);
            this.addFieldMappings(structureMapping, (JCoRecord)field.getStructure());
            return structureMapping;
        }
        if (field.isTable()) {
            StructureMapping structureMapping = new StructureMapping(null, field.getName(), javaFieldName, null);
            this.addFieldMappings(structureMapping, (JCoRecord)field.getTable());
            return new TableMapping(List.class, null, field.getName(), javaFieldName, structureMapping, null);
        }
        return new FieldMapping(this.getAssociatedClass(field), field.getName(), javaFieldName, null);
    }

    private Class<?> getAssociatedClass(JCoField field) {
        String canonicalClassName = field.getClassNameOfValue();
        if (byte[].class.getCanonicalName().equals(canonicalClassName)) {
            return byte[].class;
        }
        try {
            return Class.forName(canonicalClassName);
        }
        catch (ClassNotFoundException e) {
            throw new InternalHiberSapException("Can not get class for class name " + canonicalClassName, (Throwable)e);
        }
    }

    private void addFieldMappings(StructureMapping structureMapping, JCoRecord jCoRecord) {
        JCoFieldIterator iter = jCoRecord.getFieldIterator();
        while (iter.hasNextField()) {
            ParameterMapping fieldParam = this.getParameterMapping(iter.nextField());
            structureMapping.addParameter(fieldParam);
        }
    }
}

