/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.hibnet.jsourcemap.SourceMap;
import org.hibnet.webpipes.Webpipe;
import org.hibnet.webpipes.WebpipeOutput;
import org.hibnet.webpipes.WebpipeUtils;

public class GenerateFilesTask
extends Task {
    private String webpipesBuilder;
    private Charset encoding = Charset.forName("UTF8");
    private File dir;

    public void setWebpipesBuilder(String webpipesBuilder) {
        this.webpipesBuilder = webpipesBuilder;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setEncoding(String charsetName) {
        this.encoding = Charset.forName(charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.webpipesBuilder == null) {
            throw new BuildException("The required parameter 'webpipesBuilder' is missing");
        }
        if (this.dir == null) {
            throw new BuildException("The required parameter 'dir' is missing");
        }
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        } else if (!this.dir.isDirectory()) {
            throw new BuildException("The parameter 'dir' must be a folder");
        }
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Map webpipes;
            Object res;
            Method m;
            Object o;
            Class<?> cl;
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            try {
                cl = Class.forName(this.webpipesBuilder);
            }
            catch (ClassNotFoundException e) {
                throw new BuildException("Could not find " + this.webpipesBuilder + ". Make sure it is in the same classpath as the ant task", (Throwable)e);
            }
            try {
                o = cl.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new BuildException("Could not instanciate " + this.webpipesBuilder + ". Make sure it has a constructor without arguments", (Throwable)e);
            }
            try {
                m = cl.getMethod("getWebpipes", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new BuildException("Could not get webpipes out of " + this.webpipesBuilder + ". Make sure it has a method 'getWebpipes' with no arguments", (Throwable)e);
            }
            try {
                res = m.invoke(o, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new BuildException("Error calling 'getWebpipes' on " + this.webpipesBuilder + " (switch to verbose to see a full stack trace with -v)", (Throwable)e);
            }
            try {
                Map casted;
                webpipes = casted = (Map)res;
            }
            catch (ClassCastException e) {
                throw new BuildException("The method 'buildWebpipes' on " + this.webpipesBuilder + " is not returning a List<Webpipe>", (Throwable)e);
            }
            for (Map.Entry webpipe : webpipes.entrySet()) {
                WebpipeOutput content;
                try {
                    content = ((Webpipe)webpipe.getValue()).getOutput();
                }
                catch (Exception e) {
                    throw new BuildException("IO error while getting contents from webpipe " + (String)webpipe.getKey() + ": " + e.getMessage(), (Throwable)e);
                }
                String path = (String)webpipe.getKey();
                path = path.replaceAll("/", File.separator).replaceAll("\\\\", File.separator);
                File dest = new File(this.dir, path);
                if (!dest.getParentFile().exists()) {
                    dest.getParentFile().mkdirs();
                } else if (!dest.getParentFile().isDirectory()) {
                    dest.getParentFile().delete();
                    dest.getParentFile().mkdirs();
                }
                try (FileOutputStream out = new FileOutputStream(dest);){
                    this.log("Generating " + dest.getAbsolutePath());
                    ((OutputStream)out).write(content.getContent().getBytes(this.encoding));
                }
                catch (IOException e) {
                    throw new BuildException("IO error while writing the file " + dest.getAbsolutePath(), (Throwable)e);
                }
                if (content.getSourceMap() == null) continue;
                File destSourceMap = new File(this.dir, path + ".map");
                try {
                    FileOutputStream out = new FileOutputStream(destSourceMap);
                    Throwable throwable = null;
                    try {
                        this.log("Generating " + destSourceMap.getAbsolutePath());
                        WebpipeUtils.serializeSourceMap((SourceMap)content.getSourceMap(), (OutputStream)out);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (IOException e) {
                    throw new BuildException("IO error while writing the file " + destSourceMap.getAbsolutePath(), (Throwable)e);
                }
            }
            this.log(webpipes.size() + " webpipes to processed");
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }
}

