/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.googleclosure;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.util.Arrays;
import java.util.logging.Level;
import org.hibnet.webpipes.Webpipe;
import org.hibnet.webpipes.WebpipeOutput;
import org.hibnet.webpipes.WebpipeUtils;
import org.hibnet.webpipes.processor.ProcessingWebpipe;
import org.hibnet.webpipes.processor.ProcessingWebpipeFactory;

public class GoogleClosureCompressorProcessor {
    public Webpipe createProcessingWebpipe(String path, Webpipe source, CompilationLevel compilationLevel) {
        return new GoogleClosureCompressorWebpipe(path, source, compilationLevel);
    }

    public ProcessingWebpipeFactory createFactory(final CompilationLevel compilationLevel) {
        return new ProcessingWebpipeFactory(){

            public Webpipe createProcessingWebpipe(String path, Webpipe source) {
                return new GoogleClosureCompressorWebpipe(path, source, compilationLevel);
            }
        };
    }

    private String compile(Webpipe webpipe, CompilationLevel compilationLevel) throws Exception {
        if (compilationLevel == null) {
            compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
        }
        String content = webpipe.getOutput().getContent();
        CompilerOptions compilerOptions = this.newCompilerOptions();
        Compiler compiler = this.newCompiler(compilerOptions, compilationLevel);
        SourceFile[] input = new SourceFile[]{SourceFile.fromCode((String)webpipe.getPath(), (String)content)};
        SourceFile[] externs = this.getExterns(webpipe);
        if (externs == null) {
            externs = new SourceFile[]{};
        }
        Result result = null;
        result = compiler.compile(Arrays.asList(externs), Arrays.asList(input), compilerOptions);
        if (!result.success) {
            throw new RuntimeException("Compilation has errors: " + Arrays.asList(result.errors));
        }
        content = compiler.toSource();
        return content;
    }

    private Compiler newCompiler(CompilerOptions compilerOptions, CompilationLevel compilationLevel) {
        Compiler.setLoggingLevel((Level)Level.SEVERE);
        Compiler compiler = new Compiler();
        compilationLevel.setOptionsForCompilationLevel(compilerOptions);
        compiler.disableThreads();
        compiler.initOptions(compilerOptions);
        return compiler;
    }

    protected SourceFile[] getExterns(Webpipe webpipe) {
        return new SourceFile[0];
    }

    protected CompilerOptions newCompilerOptions() {
        CompilerOptions options = new CompilerOptions();
        options.setCodingConvention((CodingConvention)new ClosureCodingConvention());
        options.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.WARNING);
        return options;
    }

    private final class GoogleClosureCompressorWebpipe
    extends ProcessingWebpipe {
        private CompilationLevel compilationLevel;

        private GoogleClosureCompressorWebpipe(String path, Webpipe webpipe, CompilationLevel compilationLevel) {
            super(WebpipeUtils.idOf(GoogleClosureCompressorProcessor.class, (Object[])new Object[]{webpipe, compilationLevel}), path, "googleclosure", webpipe);
            this.compilationLevel = compilationLevel;
        }

        protected WebpipeOutput fetchOutput() throws Exception {
            return new WebpipeOutput(GoogleClosureCompressorProcessor.this.compile(this.getChildWebpipe(), this.compilationLevel));
        }
    }
}

