/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.jsonhpack;

import org.hibnet.webpipes.Webpipe;
import org.hibnet.webpipes.WebpipeOutput;
import org.hibnet.webpipes.processor.ProcessingWebpipe;
import org.hibnet.webpipes.processor.ProcessingWebpipeFactory;
import org.hibnet.webpipes.processor.jsonhpack.JsonHPackRunner;

public class JsonHPackProcessor {
    private JsonHPackRunner jsonHPackRunner;

    public JsonHPackProcessor() {
        this(new JsonHPackRunner());
    }

    public JsonHPackProcessor(JsonHPackRunner jsonHPackRunner) {
        this.jsonHPackRunner = jsonHPackRunner;
    }

    public Webpipe createProcessingWebpipe(Webpipe source, boolean pack) {
        return new JsonHPackWebpipe(source, pack);
    }

    public ProcessingWebpipeFactory createFactory(final boolean pack) {
        return new ProcessingWebpipeFactory(){

            public Webpipe createProcessingWebpipe(Webpipe source) {
                return new JsonHPackWebpipe(source, pack);
            }
        };
    }

    private final class JsonHPackWebpipe
    extends ProcessingWebpipe {
        private boolean pack;

        private JsonHPackWebpipe(Webpipe webpipe, boolean pack) {
            super(webpipe);
            this.pack = pack;
        }

        protected WebpipeOutput fetchContent() throws Exception {
            return new WebpipeOutput(JsonHPackProcessor.this.jsonHPackRunner.run(this.webpipe, this.pack));
        }
    }
}

