/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.jsonhpack;

import org.hibnet.webpipes.Webpipe;
import org.hibnet.webpipes.processor.rhino.RhinoRunner;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;

public class JsonHPackRunner
extends RhinoRunner {
    protected void initScope(Context context, ScriptableObject globalScope) throws Exception {
        this.addCommon(context, globalScope);
        this.evaluateFromClasspath(context, globalScope, "/org/hibnet/webpipes/processor/jsonhpack/json.hpack.min.js");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String run(Webpipe webpipe, boolean pack) throws Exception {
        String content = webpipe.getContent().getMain();
        Context context = this.enterContext();
        try {
            boolean isEnclosed;
            ScriptableObject scope = this.createLocalScope(context);
            if (pack) {
                isEnclosed = this.isEnclosedInArray(content);
                if (!isEnclosed) {
                    content = "[" + content + "]";
                }
            } else {
                isEnclosed = this.isEnclosedInDoubleArray(content);
                if (!isEnclosed) {
                    content = "[" + content + "]";
                }
            }
            StringBuilder script = new StringBuilder();
            if (pack) {
                script.append("JSON.stringify(JSON.hpack(eval(");
            } else {
                script.append("JSON.stringify(JSON.hunpack(eval(");
            }
            script.append(this.toJSMultiLineString(content));
            if (pack) {
                script.append("), 4));");
            } else {
                script.append(")));");
            }
            String result = (String)this.evaluate(context, scope, script.toString());
            if (!isEnclosed) {
                result = this.removeEnclosedArray(result);
            }
            String string = result;
            return string;
        }
        finally {
            Context.exit();
        }
    }

    private String removeEnclosedArray(String resultAsString) {
        return resultAsString.replaceFirst("(?ims)\\[", "").replaceFirst("(?ims)\\](?!.*\\])", "");
    }

    private boolean isEnclosedInArray(String rawData) {
        return rawData.matches("(?ims)^\\s*\\[.*\\]");
    }

    private boolean isEnclosedInDoubleArray(String rawData) {
        return rawData.matches("(?ims)^\\s*\\[\\[.*\\]\\]");
    }
}

