/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.less;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.DefaultLessCompiler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hibnet.webpipes.Webpipe;
import org.hibnet.webpipes.WebpipeOutput;
import org.hibnet.webpipes.WebpipeUtils;
import org.hibnet.webpipes.processor.ProcessingWebpipe;
import org.hibnet.webpipes.processor.less.Less4jProcessor;
import org.hibnet.webpipes.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Less4jWebpipe
extends ProcessingWebpipe {
    private static final Logger LOG = LoggerFactory.getLogger(Less4jProcessor.class);
    private static final LessCompiler compiler = new DefaultLessCompiler();
    private List<Resource> importedResources = new ArrayList<Resource>();

    public Less4jWebpipe(Webpipe webpipe) {
        super(webpipe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebpipeOutput fetchContent() throws Exception {
        List<Resource> list = this.importedResources;
        synchronized (list) {
            this.importedResources.clear();
            String content = this.webpipe.getOutput().getContent();
            LessSource.StringSource lessSource = this.webpipe instanceof Resource ? new RelativeAwareLessSource((Resource)this.webpipe, content) : new LessSource.StringSource(content);
            LessCompiler.CompilationResult result = compiler.compile((LessSource)lessSource);
            this.logWarnings(result);
            return new WebpipeOutput(result.getCss(), WebpipeUtils.parseSourceMap((String)result.getSourceMap()));
        }
    }

    public boolean refresh() throws IOException {
        boolean needUpdate = this.refreshChildren();
        boolean bl = needUpdate = needUpdate || this.webpipe.refresh();
        if (needUpdate) {
            this.invalidateContentCache();
        }
        return needUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Webpipe> buildChildrenList() throws IOException {
        List<Resource> list = this.importedResources;
        synchronized (list) {
            return new ArrayList<Resource>(this.importedResources);
        }
    }

    private void logWarnings(LessCompiler.CompilationResult result) {
        if (!result.getWarnings().isEmpty()) {
            LOG.warn("Less warnings are:");
            for (LessCompiler.Problem problem : result.getWarnings()) {
                LOG.warn(this.problemAsString(problem));
            }
        }
    }

    private String problemAsString(LessCompiler.Problem problem) {
        return String.format("%s:%s %s.", problem.getLine(), problem.getCharacter(), problem.getMessage());
    }

    private class RelativeAwareLessSource
    extends LessSource.StringSource {
        private Resource resource;

        public RelativeAwareLessSource(Resource resource, String content) {
            super(content);
            this.resource = resource;
        }

        public LessSource relativeSource(String relativePath) throws LessSource.StringSourceException {
            try {
                Resource relativeResource = this.resource.resolve(relativePath);
                Less4jWebpipe.this.importedResources.add(relativeResource);
                return new RelativeAwareLessSource(relativeResource, relativeResource.getOutput().getContent());
            }
            catch (Exception e) {
                LOG.error("Failed to compute relative resource: {}", (Object)this.resource, (Object)e);
                throw new LessSource.StringSourceException();
            }
        }
    }
}

