/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.less;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.DefaultLessCompiler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hibnet.webpipes.Webpipe;
import org.hibnet.webpipes.WebpipeOutput;
import org.hibnet.webpipes.WebpipeUtils;
import org.hibnet.webpipes.processor.ProcessingWebpipe;
import org.hibnet.webpipes.processor.ProcessingWebpipeFactory;
import org.hibnet.webpipes.resource.Resource;

public class Less4jProcessor
implements ProcessingWebpipeFactory {
    private static final LessCompiler compiler = new DefaultLessCompiler();

    public Webpipe createProcessingWebpipe(String path, Webpipe source) {
        return new Less4jWebpipe(path, source);
    }

    private static class Less4jWebpipe
    extends ProcessingWebpipe {
        private List<Resource> importedResources = new ArrayList<Resource>();

        public Less4jWebpipe(String path, Webpipe webpipe) {
            super(WebpipeUtils.idOf(Less4jProcessor.class, (Object[])new Object[]{webpipe}), path, "less4j", webpipe);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected WebpipeOutput fetchOutput() throws Exception {
            List<Resource> list = this.importedResources;
            synchronized (list) {
                this.importedResources.clear();
                Webpipe webpipe = this.getChildWebpipe();
                String content = webpipe.getOutput().getContent();
                LessSource.StringSource lessSource = webpipe instanceof Resource ? new RelativeAwareLessSource((Resource)webpipe, content) : new LessSource.StringSource(content, webpipe.getPath());
                LessCompiler.CompilationResult result = compiler.compile((LessSource)lessSource);
                this.logWarnings(result);
                return new WebpipeOutput(result.getCss(), WebpipeUtils.parseSourceMap((String)result.getSourceMap()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean refresh() throws IOException {
            boolean refresh = false;
            List<Resource> list = this.importedResources;
            synchronized (list) {
                for (Webpipe webpipe : this.importedResources) {
                    refresh = refresh || webpipe.refresh();
                }
            }
            boolean bl = refresh = refresh || this.getChildWebpipe().refresh();
            if (refresh) {
                this.invalidateOutputCache();
            }
            return refresh;
        }

        private void logWarnings(LessCompiler.CompilationResult result) {
            if (!result.getWarnings().isEmpty()) {
                this.LOG.warn("Less warnings are:");
                for (LessCompiler.Problem problem : result.getWarnings()) {
                    this.LOG.warn(this.problemAsString(problem));
                }
            }
        }

        private String problemAsString(LessCompiler.Problem problem) {
            return String.format("%s:%s %s.", problem.getLine(), problem.getCharacter(), problem.getMessage());
        }

        private class RelativeAwareLessSource
        extends LessSource.StringSource {
            private Resource resource;

            public RelativeAwareLessSource(Resource resource, String content) {
                super(content, resource.getPath());
                this.resource = resource;
            }

            public LessSource relativeSource(String relativePath) throws LessSource.StringSourceException {
                try {
                    Resource relativeResource = this.resource.resolve(relativePath);
                    Less4jWebpipe.this.importedResources.add(relativeResource);
                    return new RelativeAwareLessSource(relativeResource, relativeResource.getOutput().getContent());
                }
                catch (Exception e) {
                    Less4jWebpipe.this.LOG.error("Failed to compute relative resource: {}", (Object)this.resource, (Object)e);
                    throw new LessSource.StringSourceException();
                }
            }
        }
    }
}

