/*
 *  Copyright 2015 WebPipes contributors
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.hibnet.webpipes.processor.rhino;

import org.hibnet.webpipes.Webpipe;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;

public abstract class SimpleRhinoRunner extends RhinoRunner {

    public String run(Webpipe webpipe) throws Exception {
        Context context = enterContext();
        try {
            ScriptableObject scope = createLocalScope(context);
            return run(webpipe, context, scope);
        } finally {
            Context.exit();
        }
    }

    abstract protected String run(Webpipe webpipe, Context context, ScriptableObject scope) throws Exception;

}
