/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.rhino;

import java.net.URI;
import org.hibnet.webpipes.Webpipe;
import org.hibnet.webpipes.processor.rhino.AbstractJsRequireHelper;
import org.hibnet.webpipes.resource.ClasspathResource;
import org.hibnet.webpipes.resource.Resource;
import org.hibnet.webpipes.resource.WebJarHelper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.commonjs.module.ModuleScript;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.Require;
import org.mozilla.javascript.commonjs.module.RequireBuilder;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RhinoRunner {
    private static final Logger logger = LoggerFactory.getLogger(RhinoRunner.class);
    protected static Resource commonsScript = new ClasspathResource("commons.js", RhinoRunner.class);
    protected static Resource envScript = new ClasspathResource("env.rhino.min.js", RhinoRunner.class);
    protected static Resource sourceMapScript = new ClasspathResource("source-map.min.js", RhinoRunner.class);
    private static String rjsScript;
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private ScriptableObject globalScope;

    public RhinoRunner() {
        Context context = this.enterContext();
        try {
            this.globalScope = context.initStandardObjects();
            this.initScope(context, this.globalScope);
            this.globalScope.sealObject();
        }
        catch (Exception e) {
            throw new RuntimeException("The resources necessary to initialize the processor could not be accessed", e);
        }
        finally {
            Context.exit();
        }
    }

    protected Context enterContext() {
        Context context = Context.enter();
        context.setOptimizationLevel(-1);
        context.setErrorReporter((ErrorReporter)new ToolErrorReporter(false));
        context.setLanguageVersion(180);
        return context;
    }

    protected void initScope(Context context, ScriptableObject globalScope) throws Exception {
    }

    protected void addCommon(Context context, ScriptableObject scope) throws Exception {
        this.evaluate(context, scope, commonsScript);
    }

    protected void addClientSideEnvironment(Context context, ScriptableObject scope) throws Exception {
        this.evaluate(context, scope, envScript);
    }

    protected void addSourceMap(Context context, ScriptableObject scope) throws Exception {
        this.evaluate(context, scope, sourceMapScript);
    }

    protected void addRequire(Context context, ScriptableObject scope, AbstractJsRequireHelper jsRequireHelper) throws Exception {
        scope.defineProperty("__JsRequireHelper__", (Object)jsRequireHelper, 13);
        scope.defineFunctionProperties(new String[]{"load", "print"}, AbstractJsRequireHelper.class, 2);
        Scriptable argsObj = context.newArray((Scriptable)scope, new Object[0]);
        scope.defineProperty("arguments", (Object)argsObj, 2);
        this.evaluate(context, scope, rjsScript, "r.js");
    }

    protected void runRequire(Context context, ScriptableObject scope, String ... libs) {
        StringBuilder script = new StringBuilder();
        script.append("require([");
        boolean first = true;
        for (String lib : libs) {
            if (first) {
                first = false;
            } else {
                script.append(",");
            }
            script.append("'");
            script.append(lib);
            script.append("'");
        }
        script.append("])\n");
        this.evaluate(context, scope, script.toString());
    }

    protected ScriptableObject createLocalScope(Context context) {
        ScriptableObject scope = (ScriptableObject)context.newObject((Scriptable)this.globalScope);
        scope.setPrototype(null);
        scope.setParentScope((Scriptable)this.globalScope);
        return scope;
    }

    protected <T> T evaluate(Context context, ScriptableObject scope, String script, String sourceName) {
        try {
            Object result = context.evaluateString((Scriptable)scope, script, sourceName, 1, null);
            return (T)result;
        }
        catch (RhinoException e) {
            logger.error("Error executing the js '" + sourceName + "': '" + e.getMessage() + "'\n" + e.getScriptStackTrace());
            throw e;
        }
    }

    protected <T> T evaluate(Context context, ScriptableObject scope, String script) {
        return this.evaluate(context, scope, script, this.getClass().getSimpleName());
    }

    protected <T> T evaluate(Context context, ScriptableObject scope, Resource script) throws Exception {
        return this.evaluate(context, scope, script.getOutput().getContent(), script.getName());
    }

    protected <T> T evaluateFromClasspath(Context context, ScriptableObject scope, String path) throws Exception {
        return this.evaluate(context, scope, (Resource)new ClasspathResource(path));
    }

    protected <T> T evaluateFromWebjar(Context context, ScriptableObject scope, String path) throws Exception {
        return this.evaluate(context, scope, WebJarHelper.getResource((String)path));
    }

    protected Scriptable setupModule(Context context, ScriptableObject scope, final Resource moduleResource, String moduleId) {
        RequireBuilder requireBuilder = new RequireBuilder();
        requireBuilder.setSandboxed(false);
        requireBuilder.setModuleScriptProvider(new ModuleScriptProvider(){

            public ModuleScript getModuleScript(Context cx, String moduleId, URI moduleUri, URI baseUri, Scriptable paths) throws Exception {
                Script script = cx.compileString(moduleResource.getOutput().getContent(), moduleResource.getName(), 1, null);
                return new ModuleScript(script, URI.create(moduleResource.getName()), URI.create(moduleResource.getName()));
            }
        });
        Require require = requireBuilder.createRequire(context, (Scriptable)scope);
        return require.requireMain(context, moduleId);
    }

    protected NativeObject callModuleFunction(Context context, ScriptableObject scope, Scriptable module, String functionName, String[] args) {
        Function function = (Function)module.get(functionName, (Scriptable)scope);
        return (NativeObject)function.call(context, (Scriptable)scope, module, (Object[])args);
    }

    protected String buildSimpleRunScript(String jsFunction, String content, String ... extraArgs) {
        StringBuilder command = new StringBuilder(jsFunction);
        command.append("(");
        this.appendJSMultiLineString(command, content);
        if (extraArgs != null) {
            for (String extraArg : extraArgs) {
                command.append(",");
                command.append(extraArg);
            }
        }
        command.append(")");
        return command.toString();
    }

    protected String toJSMultiLineString(String data) {
        StringBuilder buffer = new StringBuilder();
        this.appendJSMultiLineString(buffer, data);
        return buffer.toString();
    }

    protected void appendJSMultiLineString(StringBuilder buffer, String data) {
        buffer.append("[");
        if (data != null) {
            String[] lines = data.split("\n");
            if (lines.length == 0) {
                buffer.append("\"\"");
            }
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                buffer.append("\"");
                buffer.append(line.replace("\\", "\\\\").replace("\"", "\\\"").replaceAll("\\r|\\n", ""));
                if (lines.length == 1) {
                    buffer.append("\\n");
                }
                buffer.append("\"");
                if (i >= lines.length - 1) continue;
                buffer.append(",");
            }
        }
        buffer.append("].join(\"\\n\")");
    }

    protected String getVarName(Webpipe webpipe) {
        String name = webpipe.getName();
        int i = name.lastIndexOf(".");
        if (i > 0) {
            return name.substring(0, i);
        }
        return name;
    }

    static {
        try {
            rjsScript = WebJarHelper.getResource((String)"r.js").getOutput().getContent();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (rjsScript.startsWith("#!")) {
            rjsScript = rjsScript.substring(rjsScript.indexOf(10));
        }
    }
}

