/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.yui;

import java.io.StringReader;
import java.io.StringWriter;
import org.hibnet.webpipes.Webpipe;
import org.hibnet.webpipes.WebpipeOutput;
import org.hibnet.webpipes.processor.ProcessingWebpipe;
import org.hibnet.webpipes.processor.ProcessingWebpipeFactory;
import org.hibnet.webpipes.processor.yui.YuiProxy;

public class YuiJsCompressorProcessor {
    public Webpipe createProcessingWebpipe(Webpipe source, int linebreak, boolean munge, boolean verbose, boolean preserveAllSemiColons, boolean disableOptimizations) {
        return new YuiJsCompressorWebpipe(source, linebreak, munge, verbose, preserveAllSemiColons, disableOptimizations);
    }

    public ProcessingWebpipeFactory createFactory(final int linebreak, final boolean munge, final boolean verbose, final boolean preserveAllSemiColons, final boolean disableOptimizations) {
        return new ProcessingWebpipeFactory(){

            public Webpipe createProcessingWebpipe(Webpipe source) {
                return new YuiJsCompressorWebpipe(source, linebreak, munge, verbose, preserveAllSemiColons, disableOptimizations);
            }
        };
    }

    private final class YuiJsCompressorWebpipe
    extends ProcessingWebpipe {
        private int linebreak;
        private boolean munge;
        private boolean verbose;
        private boolean preserveAllSemiColons;
        private boolean disableOptimizations;

        private YuiJsCompressorWebpipe(Webpipe webpipe, int linebreak, boolean munge, boolean verbose, boolean preserveAllSemiColons, boolean disableOptimizations) {
            super(webpipe);
            this.linebreak = linebreak;
            this.munge = munge;
            this.verbose = verbose;
            this.preserveAllSemiColons = preserveAllSemiColons;
            this.disableOptimizations = disableOptimizations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected WebpipeOutput fetchContent() throws Exception {
            String content = this.webpipe.getContent().getMain();
            try (StringWriter writer = new StringWriter();){
                YuiProxy.Instance.compressJavascript(new StringReader(content), writer, this.linebreak, this.munge, this.verbose, this.preserveAllSemiColons, this.disableOptimizations);
                content = ((Object)writer).toString();
            }
            return new WebpipeOutput(content);
        }
    }
}

