/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.yui;

import java.io.StringReader;
import java.io.StringWriter;
import org.hibnet.webpipes.Webpipe;
import org.hibnet.webpipes.WebpipeOutput;
import org.hibnet.webpipes.processor.ProcessingWebpipe;
import org.hibnet.webpipes.processor.ProcessingWebpipeFactory;
import org.hibnet.webpipes.processor.yui.YuiProxy;

public class YuiCssCompressorProcessor {
    public Webpipe createProcessingWebpipe(Webpipe source, int linebreak) {
        return new YuiCssCompressorWebpipe(source, linebreak);
    }

    public ProcessingWebpipeFactory createFactory(final int linebreak) {
        return new ProcessingWebpipeFactory(){

            public Webpipe createProcessingWebpipe(Webpipe source) {
                return new YuiCssCompressorWebpipe(source, linebreak);
            }
        };
    }

    private final class YuiCssCompressorWebpipe
    extends ProcessingWebpipe {
        private int linebreak;

        private YuiCssCompressorWebpipe(Webpipe webpipe, int linebreak) {
            super(webpipe);
            this.linebreak = linebreak;
        }

        protected WebpipeOutput fetchContent() throws Exception {
            String content = this.webpipe.getOutput().getContent();
            try (StringWriter writer = new StringWriter();){
                YuiProxy.Instance.compressCSS(new StringReader(content), writer, this.linebreak);
                content = ((Object)writer).toString();
            }
            return new WebpipeOutput(content);
        }
    }
}

