/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.yui;

import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

class YuiProxy {
    static final YuiProxy Instance = new YuiProxy();
    private URLClassLoader cl = new URLClassLoader(new URL[]{this.getClass().getResource("jar/yuicompressor-2.4.8.jar")});
    private Constructor<?> jsCompressorConstructor;
    private Method jsCompressMethod;
    private Constructor<?> cssCompressorConstructor;
    private Method cssCompressMethod;

    public YuiProxy() {
        try {
            Class<?> jsCompressorClass = this.cl.loadClass("com.yahoo.platform.yui.compressor.JavaScriptCompressor");
            Class<?> errorReporterClass = this.cl.loadClass("org.mozilla.javascript.ErrorReporter");
            this.jsCompressorConstructor = jsCompressorClass.getConstructor(Reader.class, errorReporterClass);
            this.jsCompressMethod = jsCompressorClass.getMethod("compress", Writer.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            Class<?> cssCompressorClass = this.cl.loadClass("com.yahoo.platform.yui.compressor.CssCompressor");
            this.cssCompressorConstructor = cssCompressorClass.getConstructor(Reader.class);
            this.cssCompressMethod = cssCompressorClass.getMethod("compress", Writer.class, Integer.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public String compressJavascript(Reader reader, Writer writer, int linebreak, boolean munge, boolean verbose, boolean preserveAllSemiColons, boolean disableOptimizations) {
        Object res;
        try {
            Object jsCompressor = this.jsCompressorConstructor.newInstance(reader, null);
            res = this.jsCompressMethod.invoke(jsCompressor, writer, linebreak, munge, verbose, preserveAllSemiColons, disableOptimizations);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return (String)res;
    }

    public String compressCSS(Reader reader, Writer writer, int linebreak) {
        Object res;
        try {
            Object cssCompressor = this.cssCompressorConstructor.newInstance(reader);
            res = this.cssCompressMethod.invoke(cssCompressor, writer, linebreak);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return (String)res;
    }
}

