/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hibnet.webpipes.WebpipeCache;
import org.hibnet.webpipes.processor.ProcessorPipeline;
import org.hibnet.webpipes.processor.ResourceProcessor;
import org.hibnet.webpipes.resource.Resource;
import org.hibnet.webpipes.resource.ResourceFactory;
import org.hibnet.webpipes.resource.ResourceRefresher;

public class Webpipe {
    private final List<Resource> resources = Collections.synchronizedList(new ArrayList());
    private ResourceRefresher resourceRefresher;
    private ResourceFactory resourceFactory;
    private ProcessorPipeline processorPipeline = new ProcessorPipeline();
    private volatile boolean firstFetch = true;
    private WebpipeCache webpipeCache = null;
    private volatile List<String> contents;
    private List<String> paths;

    public Webpipe(ResourceFactory resourceFactory, ResourceRefresher resourceRefresher, String ... paths) {
        this.resourceFactory = resourceFactory;
        this.resourceRefresher = resourceRefresher;
        if (resourceRefresher != null) {
            resourceRefresher.addWebpipe(this);
        }
        this.paths = Arrays.asList(paths);
    }

    public void setWebpipeCache(WebpipeCache webpipeCache) {
        this.webpipeCache = webpipeCache;
    }

    public void setProcessorPipeline(ProcessorPipeline pipeline) {
        this.processorPipeline = pipeline;
    }

    public List<Resource> getResources() {
        return new ArrayList<Resource>(this.resources);
    }

    public List<String> getPaths() {
        return this.paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getContents() throws IOException {
        if (this.contents == null) {
            Webpipe webpipe = this;
            synchronized (webpipe) {
                if (this.contents == null) {
                    if (this.firstFetch) {
                        if (this.webpipeCache != null) {
                            this.contents = this.webpipeCache.getContents(this);
                        }
                        this.firstFetch = false;
                    }
                    if (this.contents == null) {
                        this.contents = this.fetchContents();
                    }
                    if (this.webpipeCache != null) {
                        this.webpipeCache.storeContents(this, this.contents);
                    }
                }
            }
        }
        return this.contents;
    }

    protected List<String> fetchContents() throws IOException {
        if (this.processorPipeline == null) {
            return null;
        }
        try {
            return this.processorPipeline.buildContents(this.getResources());
        }
        catch (Exception e) {
            throw new IOException("Failure of the pipeline of processors", e);
        }
    }

    public synchronized void invalidateCachedContent() {
        this.contents = null;
    }

    public synchronized Webpipe addResource(Resource resource) {
        if (this.resourceRefresher != null) {
            this.resourceRefresher.addResource(resource);
        }
        this.resources.add(resource);
        this.invalidateCachedContent();
        return this;
    }

    public void addResource(String resource) {
        if (this.resourceFactory == null) {
            throw new IllegalStateException("Unconfigured resource factory");
        }
        int i = resource.indexOf(":");
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        String type = resource.substring(0, i);
        String path = resource.substring(i + 1);
        this.addResource(this.resourceFactory.get(type, path));
    }

    public synchronized void setResources(List<String> resources) {
        this.resources.clear();
        for (String resource : resources) {
            this.addResource(resource);
        }
    }

    public void setResource(String resource) {
        this.setResources(Collections.singletonList(resource));
    }

    public void setPreProcessors(List<ResourceProcessor> preProcessors) {
        this.processorPipeline.setPreProcessors(preProcessors);
    }

    public void setPostProcessors(List<ResourceProcessor> postProcessors) {
        this.processorPipeline.setPostProcessors(postProcessors);
    }

    public void setPreProcessor(ResourceProcessor preProcessor) {
        this.setPreProcessors(Collections.singletonList(preProcessor));
    }

    public void setPostProcessor(ResourceProcessor postProcessor) {
        this.setPostProcessors(Collections.singletonList(postProcessor));
    }
}

