/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibnet.webpipes.Webpipe;
import org.hibnet.webpipes.resource.Resource;

public class WebpipeCache {
    private Charset UTF8 = Charset.forName("UTF-8");
    private File cacheDir;

    public WebpipeCache(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    public List<String> getContents(Webpipe pipe) throws IOException {
        File sha1File = new File(this.cacheDir, pipe.getPaths().get(0) + ".sha1");
        if (!sha1File.exists()) {
            return null;
        }
        byte[] expectedSha1 = this.computeSHA1(pipe);
        if (sha1File.length() != (long)expectedSha1.length) {
            return null;
        }
        byte[] actualSha1 = this.readFile(sha1File);
        if (!Arrays.equals(expectedSha1, actualSha1)) {
            return null;
        }
        ArrayList<String> contents = new ArrayList<String>();
        for (String path : pipe.getPaths()) {
            byte[] data = this.readFile(new File(this.cacheDir, path));
            contents.add(new String(data, this.UTF8));
        }
        return contents;
    }

    private byte[] readFile(File file) throws IOException, FileNotFoundException {
        int size = (int)file.length();
        byte[] data = new byte[size];
        int readed = 0;
        try (FileInputStream in = new FileInputStream(file);){
            for (int offset = 0; offset < size && (readed = ((InputStream)in).read(data, offset, size - offset)) != -1; offset += readed) {
            }
        }
        return data;
    }

    public void storeContents(Webpipe webpipe, List<String> contents) throws IOException {
        byte[] sha1 = this.computeSHA1(webpipe);
        try (FileOutputStream out = new FileOutputStream(new File(this.cacheDir, webpipe.getPaths().get(0) + ".sha1"));){
            ((OutputStream)out).write(sha1);
        }
        for (int i = 0; i < webpipe.getPaths().size(); ++i) {
            String path = webpipe.getPaths().get(i);
            path = path.replaceAll("/", File.separator).replaceAll("\\", File.separator);
            try (FileOutputStream out = new FileOutputStream(new File(this.cacheDir, path));){
                ((OutputStream)out).write(contents.get(i).getBytes(this.UTF8));
                continue;
            }
        }
    }

    private byte[] computeSHA1(Webpipe webpipe) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-1 is not supported", e);
        }
        for (String path : webpipe.getPaths()) {
            digest.update(path.getBytes(this.UTF8));
            digest.update((byte)10);
        }
        for (Resource r : webpipe.getResources()) {
            digest.update(r.getContent().getBytes(this.UTF8));
            digest.update((byte)10);
        }
        byte[] sha1 = digest.digest();
        return sha1;
    }
}

