/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.hibnet.webpipes.processor.ResourceProcessor;
import org.hibnet.webpipes.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorPipeline {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private List<ResourceProcessor> preProcessors = new ArrayList<ResourceProcessor>();
    private List<ResourceProcessor> postProcessors = new ArrayList<ResourceProcessor>();
    private boolean ignoreMissingResources = false;
    private boolean ignoreFailingProcessor = false;

    public void addPreProcessors(ResourceProcessor preProcessor) {
        this.preProcessors.add(preProcessor);
    }

    public void addPostProcessors(ResourceProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
    }

    public void setPreProcessors(List<ResourceProcessor> preProcessors) {
        this.preProcessors = preProcessors;
    }

    public void setPostProcessors(List<ResourceProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    public void setIgnoreMissingResources(boolean ignoreMissingResources) {
        this.ignoreMissingResources = ignoreMissingResources;
    }

    public void setIgnoreFailingProcessor(boolean ignoreFailingProcessor) {
        this.ignoreFailingProcessor = ignoreFailingProcessor;
    }

    public List<String> buildContents(List<Resource> resources) throws Exception {
        String merged = this.processAndMerge(resources);
        String result = this.applyPostProcessors(merged);
        return Arrays.asList(result);
    }

    private String processAndMerge(List<Resource> resources) throws Exception {
        StringBuffer result = new StringBuffer();
        for (Resource resource : resources) {
            result.append(this.applyPreProcessors(resource));
        }
        return result.toString();
    }

    private String applyPreProcessors(Resource resource) throws Exception {
        String content = null;
        try {
            content = resource.getContent();
        }
        catch (IOException e) {
            if (this.ignoreMissingResources) {
                return "";
            }
            throw e;
        }
        Iterator<ResourceProcessor> i$ = this.preProcessors.iterator();
        if (i$.hasNext()) {
            ResourceProcessor processor = i$.next();
            try {
                content = processor.process(resource, content);
            }
            catch (Exception e) {
                if (this.ignoreFailingProcessor) {
                    this.LOG.error("Exception while applying pre processor {} on the resource {}; ignoring it", new Object[]{processor.getClass().getSimpleName(), resource, e});
                }
                throw e;
            }
            return content;
        }
        return content + "\n";
    }

    private String applyPostProcessors(String content) throws Exception {
        for (ResourceProcessor processor : this.postProcessors) {
            try {
                content = processor.process(null, content);
            }
            catch (Exception e) {
                if (this.ignoreFailingProcessor) {
                    this.LOG.warn("Exception while applying post processor {} on the merged resource; ignoring it", (Object)processor.getClass().getSimpleName(), (Object)e);
                    continue;
                }
                throw e;
            }
        }
        return content;
    }
}

