/*
 * Decompiled with CFR 0.152.
 */
package org.hibnet.webpipes.processor.cjson;

import java.io.IOException;
import org.hibnet.webpipes.processor.rhino.RhinoBasedProcessor;
import org.hibnet.webpipes.resource.Resource;
import org.hibnet.webpipes.resource.ResourceFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class CJsonProcessor
extends RhinoBasedProcessor {
    private boolean pack;

    public CJsonProcessor(ResourceFactory resourceFactory, boolean pack) {
        super(resourceFactory);
        this.pack = pack;
    }

    @Override
    protected void initScope(Context context, ScriptableObject globalScope) throws IOException {
        this.addCommon(context, (Scriptable)globalScope);
        this.addClientSideEnvironment(context, (Scriptable)globalScope);
        this.evaluateFromClasspath(context, (Scriptable)globalScope, "/org/hibnet/webpipes/processor/cjson/cjson.min.js");
    }

    @Override
    protected String process(Context context, Scriptable scope, Resource resource, String content) throws Exception {
        StringBuilder script = new StringBuilder();
        if (this.pack) {
            script.append("CJSON.stringify(JSON.parse(");
        } else {
            script.append("JSON.stringify(CJSON.parse(");
        }
        script.append(this.toJSMultiLineString(content));
        script.append("));");
        return (String)this.evaluate(context, scope, script.toString());
    }
}

